'use strict';

const {isNext, isNextParent} = require('../../is');

module.exports.TSEnumDeclaration = {
    beforeIf(path) {
        return path.node.const;
    },
    before(path, {print}) {
        print('const ');
    },
    print(path, {print, traverse, indent}) {
        print('enum ');
        print('__id');
        print(' ');
        print('{');
        
        indent.inc();
        print.newline();
        
        for (const member of path.get('members')) {
            traverse(member);
            print(',');
            print.newline();
        }
        
        indent.dec();
        print('}');
    },
    afterSatisfy: () => [isNext, isNextParent],
    after(path, {print}) {
        print.breakline();
    },
};
