"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.run = exports.m = exports.matchers = exports.types = exports.t = void 0;
const path_1 = require("path");
const CLIEngine_1 = require("./CLIEngine");
const Config_1 = require("./Config");
const Options_1 = require("./Options");
const TransformRunner_1 = require("./TransformRunner");
const matchers = require("@codemod/matchers");
exports.matchers = matchers;
exports.m = matchers;
__exportStar(require("./defineCodemod"), exports);
var utils_1 = require("@codemod/utils");
Object.defineProperty(exports, "t", { enumerable: true, get: function () { return utils_1.t; } });
Object.defineProperty(exports, "types", { enumerable: true, get: function () { return utils_1.types; } });
function optionAnnotation(value) {
    if (Array.isArray(value) || value instanceof Map) {
        return ' (allows multiple)';
    }
    else if (typeof value === 'boolean') {
        return ` (default: ${value ? 'on' : 'off'})`;
    }
    else if (typeof value === 'string') {
        return ` (default: ${value})`;
    }
    else {
        return '';
    }
}
function printHelp(argv, out) {
    const $0 = (0, path_1.basename)(argv[1]);
    const defaults = new Config_1.Config();
    out.write(`
${$0} [OPTIONS] [PATH … | --stdio]

OPTIONS
  -p, --plugin PLUGIN               Transform sources with PLUGIN${optionAnnotation(defaults.localPlugins)}.
      --remote-plugin URL           Fetch a plugin from URL${optionAnnotation(defaults.remotePlugins)}.
  -o, --plugin-options OPTS         JSON-encoded OPTS for the last plugin provided${optionAnnotation(defaults.pluginOptions)}.
      --parser-plugins PLUGINS      Comma-separated PLUGINS to use with @babel/parser.
  -r, --require PATH                Require PATH before transform${optionAnnotation(defaults.requires)}.
      --add-extension EXT           Add an extension to the list of supported extensions.
      --extensions EXTS             Comma-separated extensions to process (default: "${Array.from(defaults.extensions).join(',')}").
      --source-type                 Parse as "module", "script", or "unambiguous" (meaning babel
                                    will try to guess, default: "${defaults.sourceType}").
      --[no-]transpile-plugins      Transpile plugins to enable future syntax${optionAnnotation(defaults.transpilePlugins)}.
  -s, --stdio                       Read source from stdin and print to stdout${optionAnnotation(defaults.stdio)}.
  -d, --dry                         Run plugins without modifying files on disk${optionAnnotation(defaults.dry)}.
      --version                     Print the version of ${$0}.
  -h, --help                        Show this help message.

  NOTE: \`--remote-plugin\` should only be used as a convenience to load code that you or someone
        you trust wrote. It will run with your full user privileges, so please exercise caution!

EXAMPLES
  # Run with a relative plugin on all files in \`src/\`.
  $ ${$0} -p ./typecheck.js src/

  # Run with a remote plugin from astexplorer.net on all files in \`src/\`.
  $ ${$0} --remote-plugin 'https://astexplorer.net/#/gist/688274…' src/

  # Run with multiple plugins.
  $ ${$0} -p ./a.js -p ./b.js some-file.js

  # Transform TypeScript sources.
  # ${$0} -p ./a.js my-typescript-file.ts a-component.tsx

  # Run with a plugin in \`node_modules\` on stdin.
  $ ${$0} -s -p babel-plugin-typecheck <<EOS
  function add(a: number, b: number): number {
    return a + b;
  }
  EOS

  # Pass options to a plugin.
  $ ${$0} -p ./a.js -o a='{"foo":true}' src/

  # Pass options from a config file to a plugin.
  $ ${$0} -p ./a.js -o a=@opts.json src/

  # Run with a plugin written in TypeScript.
  $ ${$0} -p ./some-plugin.ts src/
  `.trim());
    out.write('\n');
}
function printVersion(argv, out) {
    // eslint-disable-next-line @typescript-eslint/no-var-requires
    out.write(require('../package.json').version);
    out.write('\n');
}
function run(argv) {
    return __awaiter(this, void 0, void 0, function* () {
        let command;
        try {
            command = new Options_1.Options(argv.slice(2)).parse();
        }
        catch (error) {
            process.stderr.write(`ERROR: ${error.message}\n`);
            printHelp(argv, process.stderr);
            return 1;
        }
        if (command.kind === 'help') {
            printHelp(argv, process.stdout);
            return 0;
        }
        if (command.kind === 'version') {
            printVersion(argv, process.stdout);
            return 0;
        }
        const config = command.config;
        const dim = process.stdout.isTTY ? '\x1b[2m' : '';
        const reset = process.stdout.isTTY ? '\x1b[0m' : '';
        function onTransform(result) {
            const relativePath = (0, path_1.relative)(process.cwd(), result.source.path);
            if (result.kind === TransformRunner_1.SourceTransformResultKind.Transformed) {
                if (!config.stdio) {
                    if (result.output === result.source.content) {
                        process.stdout.write(`${dim}${relativePath}${reset}\n`);
                    }
                    else {
                        process.stdout.write(`${relativePath}\n`);
                    }
                }
            }
            else if (result.error) {
                if (!config.stdio) {
                    process.stderr.write(`Encountered an error while processing ${relativePath}:\n`);
                }
                process.stderr.write(`${result.error.stack}\n`);
            }
        }
        const { stats } = yield new CLIEngine_1.CLIEngine(config, onTransform).run();
        if (!config.stdio) {
            if (config.dry) {
                process.stdout.write('DRY RUN: no files affected\n');
            }
            process.stdout.write(`${stats.total} file(s), ${stats.modified} modified, ${stats.errors} errors\n`);
        }
        // exit status is number of errors up to byte max value
        return Math.min(stats.errors, 255);
    });
}
exports.run = run;
exports.default = run;
//# sourceMappingURL=index.js.map