import { Response } from 'got';
import Resolver from './Resolver';
export declare class NetworkLoadError extends Error {
    readonly response: Response<string>;
    constructor(response: Response<string>);
}
/**
 * Resolves plugins over the network to a local file.
 *
 * This plugin accepts only absolute HTTP URLs.
 */
export declare class NetworkResolver implements Resolver {
    canResolve(source: string): Promise<boolean>;
    resolve(source: string): Promise<string>;
}
