/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.knowledge.search;

import io.moderne.knowledge.ComprehendCode;
import io.moderne.knowledge.KnowledgeBaseExecutionContextView;
import io.moderne.knowledge.model.ClassDescription;
import io.moderne.knowledge.model.LanguageModel;
import io.moderne.knowledge.search.SearchDesign;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.text.PlainTextParser;

public final class SearchDesignTechnique
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Query", description="Query from user to search for.", required=true)
    private final @Nullable String prompt;

    public String getDisplayName() {
        return "Search for a class that uses the given design technique";
    }

    public String getDescription() {
        return "Search for a class that uses the given design technique.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean searchResultFileExists) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)tree;
                if (PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"SearchResult.md")) {
                    searchResultFileExists.set(true);
                }
                new ComprehendCode().getVisitor().visit(tree, (Object)ctx);
                this.stopAfterPreVisit();
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(AtomicBoolean searchResultFileExists, ExecutionContext ctx) {
        String result;
        if (!searchResultFileExists.get() && (result = this.writeResult(ctx)) != null) {
            return PlainTextParser.builder().build().parse(new String[]{result}).map(sourceFile -> sourceFile.withSourcePath(Paths.get("SearchResult.md", new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean acc) {
        return Preconditions.check((Recipe)this.isSearchResultFile(), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                String result = SearchDesignTechnique.this.writeResult(ctx);
                this.stopAfterPreVisit();
                if (result == null) {
                    return tree;
                }
                return ((SourceFile)PlainTextParser.builder().build().parse(new String[]{result}).findFirst().orElseThrow()).withSourcePath(((SourceFile)tree).getSourcePath()).withId(tree.getId()).withMarkers(tree.getMarkers());
            }
        });
    }

    private @Nullable String writeResult(ExecutionContext ctx) {
        Map<JavaType.FullyQualified, ClassDescription> classDescriptions = KnowledgeBaseExecutionContextView.view(ctx).getClassDescriptions();
        StringJoiner classDescriptionTable = new StringJoiner("\n", "| Class Name                      | Description                  | Architectural Patterns  \n|---------------------------------|------------------------------|-------------------------\n", "");
        for (Map.Entry<JavaType.FullyQualified, ClassDescription> classDescription : classDescriptions.entrySet()) {
            classDescriptionTable.add("| " + String.valueOf(classDescription.getKey()) + " | " + classDescription.getValue().description() + " |" + classDescription.getValue().architecturalPatterns().stream().map(ClassDescription.ArchitecturalPattern::nameOrShortDescription).collect(Collectors.joining(", ")));
        }
        SearchDesign assistant = LanguageModel.GEMINI.getAssistant(SearchDesign.class);
        return (String)LanguageModel.GEMINI.getRateLimiter().executeSupplier(() -> assistant.writeSearchResult(this.prompt == null ? "" : this.prompt, classDescriptionTable.toString()).trim());
    }

    private FindSourceFiles isSearchResultFile() {
        return new FindSourceFiles("SearchResult.md");
    }

    @Generated
    public SearchDesignTechnique(@Nullable String prompt) {
        this.prompt = prompt;
    }

    @Generated
    public @Nullable String getPrompt() {
        return this.prompt;
    }

    @Generated
    public String toString() {
        return "SearchDesignTechnique(prompt=" + this.getPrompt() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchDesignTechnique)) {
            return false;
        }
        SearchDesignTechnique other = (SearchDesignTechnique)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        return !(this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchDesignTechnique;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        return result;
    }
}

