/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cucumber.jvm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.RemoveUnneededBlock;
import org.openrewrite.staticanalysis.UnnecessaryThrows;

class CucumberJava8ClassVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private static final String IO_CUCUMBER_JAVA = "io.cucumber.java";
    private static final String IO_CUCUMBER_JAVA8 = "io.cucumber.java8";
    private final JavaType.FullyQualified stepDefinitionsClass;
    private final String replacementImport;
    private final String template;
    private final Object[] templateParameters;

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
        J.ClassDeclaration classDeclaration = super.visitClassDeclaration(cd, (Object)ctx);
        if (!TypeUtils.isOfType((JavaType)classDeclaration.getType(), (JavaType)this.stepDefinitionsClass)) {
            return classDeclaration;
        }
        List<TypeTree> retained = this.filterImplementingInterfaces(classDeclaration);
        this.maybeAddImport(this.replacementImport);
        this.doAfterVisit((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration md, ExecutionContext ctx) {
                J.MethodDeclaration methodDeclaration = super.visitMethodDeclaration(md, (Object)ctx);
                if (methodDeclaration.isConstructor() && (methodDeclaration.getBody() == null || methodDeclaration.getBody().getStatements().isEmpty())) {
                    return null;
                }
                return methodDeclaration;
            }
        });
        this.doAfterVisit(new RemoveUnneededBlock().getVisitor());
        this.doAfterVisit(new UnnecessaryThrows().getVisitor());
        J.ClassDeclaration applied = (J.ClassDeclaration)JavaTemplate.builder((String)this.template).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"cucumber-java", "cucumber-java8"})).imports(new String[]{this.replacementImport}).build().apply(this.getCursor(), CucumberJava8ClassVisitor.coordinatesForNewMethod(classDeclaration.getBody()), this.templateParameters);
        return applied.withImplements(retained);
    }

    private List<TypeTree> filterImplementingInterfaces(J.ClassDeclaration classDeclaration) {
        ArrayList<TypeTree> retained = new ArrayList<TypeTree>();
        for (TypeTree typeTree : Optional.ofNullable(classDeclaration.getImplements()).orElse(Collections.emptyList())) {
            JavaType.Class clazz;
            if (typeTree.getType() instanceof JavaType.Class && IO_CUCUMBER_JAVA8.equals((clazz = (JavaType.Class)typeTree.getType()).getPackageName())) {
                this.maybeRemoveImport(clazz.getFullyQualifiedName());
                continue;
            }
            retained.add(typeTree);
        }
        return retained;
    }

    private static JavaCoordinates coordinatesForNewMethod(J.Block body) {
        return body.getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).filter(method -> method.getAllAnnotations().stream().anyMatch(ann -> ann.getAnnotationType().getType() != null && ((JavaType.Class)ann.getAnnotationType().getType()).getPackageName().startsWith(IO_CUCUMBER_JAVA))).map(method -> method.getCoordinates().after()).reduce((a, b) -> b).orElseGet(() -> body.getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).filter(J.MethodDeclaration::isConstructor).map(constructor -> constructor.getCoordinates().after()).reduce((a, b) -> b).orElseGet(() -> body.getCoordinates().lastStatement()));
    }

    @Generated
    public CucumberJava8ClassVisitor(JavaType.FullyQualified stepDefinitionsClass, String replacementImport, String template, Object[] templateParameters) {
        this.stepDefinitionsClass = stepDefinitionsClass;
        this.replacementImport = replacementImport;
        this.template = template;
        this.templateParameters = templateParameters;
    }
}

