/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cucumber.jvm;

import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cucumber.jvm.CucumberJava8ClassVisitor;
import org.openrewrite.cucumber.jvm.StepDefinitionArguments;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class CucumberJava8StepDefinitionToCucumberJava
extends Recipe {
    private static final String IO_CUCUMBER_JAVA8_STEP_DEFINITION = "io.cucumber.java8.* *(String, ..)";
    private static final String IO_CUCUMBER_JAVA8_STEP_DEFINITION_BODY = "io.cucumber.java8.StepDefinitionBody";
    private static final MethodMatcher STEP_DEFINITION_METHOD_MATCHER = new MethodMatcher("io.cucumber.java8.* *(String, ..)");

    public String getDisplayName() {
        return "Replace `cucumber-java8` step definitions with `cucumber-java`";
    }

    public String getDescription() {
        return "Replace `StepDefinitionBody` methods with `StepDefinitionAnnotations` on new methods with the same body.";
    }

    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(IO_CUCUMBER_JAVA8_STEP_DEFINITION, true), (TreeVisitor)new CucumberStepDefinitionBodyVisitor());
    }

    @Generated
    public CucumberJava8StepDefinitionToCucumberJava() {
    }

    @Generated
    public String toString() {
        return "CucumberJava8StepDefinitionToCucumberJava()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CucumberJava8StepDefinitionToCucumberJava)) {
            return false;
        }
        CucumberJava8StepDefinitionToCucumberJava other = (CucumberJava8StepDefinitionToCucumberJava)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CucumberJava8StepDefinitionToCucumberJava;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    static final class CucumberStepDefinitionBodyVisitor
    extends JavaVisitor<ExecutionContext> {
        CucumberStepDefinitionBodyVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, (Object)ctx);
            if (!STEP_DEFINITION_METHOD_MATCHER.matches((MethodCall)m)) {
                return m;
            }
            List arguments = m.getArguments();
            if (arguments.size() < 2) {
                return m;
            }
            Expression stringExpression = (Expression)arguments.get(0);
            if (!(stringExpression instanceof J.Literal)) {
                return (J)SearchResult.found((Tree)m, (String)"TODO Migrate manually");
            }
            J.Literal literal = (J.Literal)stringExpression;
            Expression possibleStepDefinitionBody = (Expression)arguments.get(1);
            if (!(possibleStepDefinitionBody instanceof J.Lambda) || !TypeUtils.isAssignableTo((String)CucumberJava8StepDefinitionToCucumberJava.IO_CUCUMBER_JAVA8_STEP_DEFINITION_BODY, (JavaType)possibleStepDefinitionBody.getType())) {
                return (J)SearchResult.found((Tree)m, (String)"TODO Migrate manually");
            }
            J.Lambda lambda = (J.Lambda)possibleStepDefinitionBody;
            StepDefinitionArguments stepArguments = new StepDefinitionArguments(m.getSimpleName(), literal, lambda);
            J.ClassDeclaration parentClass = (J.ClassDeclaration)this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).getValue();
            if (m.getMethodType() == null) {
                return m;
            }
            String replacementImport = String.format("%s.%s", m.getMethodType().getDeclaringType().getFullyQualifiedName().replace("java8", "java").toLowerCase(), m.getSimpleName());
            this.doAfterVisit((TreeVisitor)new CucumberJava8ClassVisitor(parentClass.getType(), replacementImport, stepArguments.template(), stepArguments.parameters()));
            return null;
        }
    }
}

