/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.docker.search;

import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.docker.DockerImageVersion;
import org.openrewrite.docker.table.DockerBaseImages;
import org.openrewrite.docker.trait.Traits;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.text.PlainText;

public class FindDockerImageUses
extends Recipe {
    transient DockerBaseImages dockerBaseImages = new DockerBaseImages(this);

    public String getDisplayName() {
        return "Find uses of docker base images";
    }

    public String getDescription() {
        return "Produce an impact analysis of base images used in Dockerfiles.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Traits.dockerfile().asVisitor((docker, ctx) -> {
            List<DockerImageVersion> froms = docker.getFroms();
            if (!froms.isEmpty()) {
                for (DockerImageVersion from : froms) {
                    this.dockerBaseImages.insertRow((ExecutionContext)ctx, new DockerBaseImages.Row(from.getImageName(), from.getVersion() == null ? "" : from.getVersion()));
                }
                return SearchResult.found((Tree)((PlainText)docker.getTree()), (String)froms.stream().map(DockerImageVersion::toString).collect(Collectors.joining(", ")));
            }
            return docker.getTree();
        });
    }
}

