/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.dotnet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.dotnet.UpgradeAssistantAnalysis;
import org.openrewrite.dotnet.UpgradeAssistantRecipe;

public final class UpgradeAssistantAnalyze
extends UpgradeAssistantRecipe {
    private static final Pattern RECOMMENDATION_SNIPPET_PATTERN = Pattern.compile("(.*)\\n\\nRecommendation:\\n\\n(.*)");
    private static final Pattern CURRENT_NEW_SNIPPET_PATTERN = Pattern.compile("Current: (.*)\\nNew: (.*)");
    private final transient UpgradeAssistantAnalysis analysisTable = new UpgradeAssistantAnalysis((Recipe)this);
    @Option(displayName="Target framework version", description="Target framework to which source project should be upgraded.", example="net9.0")
    private final String targetFramework;
    @Option(displayName="Privacy mode", description="Specifies how much data is included in the generated data table.", example="Restricted", valid={"Unrestricted", "Protected", "Restricted"})
    private final @Nullable String privacyMode;

    public String getDisplayName() {
        return "Analyze a .NET project using upgrade-assistant";
    }

    public String getDescription() {
        return "Run [upgrade-assistant analyze](https://learn.microsoft.com/en-us/dotnet/core/porting/upgrade-assistant-overview) across a repository to analyze changes required to upgrade projects to a newer version of .NET. This recipe will generate an `org.openrewrite.dotnet.UpgradeAssistantAnalysis` data table containing the report details.";
    }

    @Override
    public List<String> buildUpgradeAssistantCommand(UpgradeAssistantRecipe.Accumulator acc, ExecutionContext ctx, Path solutionFile) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getUpgradeAssistantPath().toString());
        command.add("analyze");
        command.add(solutionFile.toString());
        command.add("--source");
        command.add("Solution");
        command.add("--code");
        command.add("--privacyMode");
        command.add(Optional.ofNullable(this.privacyMode).orElse("Protected"));
        command.add("--non-interactive");
        command.add("--targetFramework");
        command.add(this.targetFramework);
        command.add("--serializer");
        command.add("JSON");
        command.add("--report");
        command.add(this.buildReportPath(acc, solutionFile).getFileName().toString());
        return command;
    }

    @Override
    public void runUpgradeAssistant(UpgradeAssistantRecipe.Accumulator acc, ExecutionContext ctx) {
        for (Path solutionFile : acc.getSolutionFiles()) {
            Path reportPath = this.buildReportPath(acc, solutionFile);
            this.deleteFile(reportPath);
            this.execUpgradeAssistant(solutionFile, acc, ctx);
        }
    }

    @Override
    protected void processOutput(Path solutionFile, Path output, UpgradeAssistantRecipe.Accumulator acc) {
        Path reportPath = this.buildReportPath(acc, solutionFile);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode reportNode = objectMapper.readTree(reportPath.toFile());
            JsonNode rulesNode = reportNode.get("rules");
            Iterator iterator = rulesNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                acc.addRule((String)entry.getKey(), (JsonNode)entry.getValue());
            }
            for (JsonNode projectNode : reportNode.get("projects")) {
                for (JsonNode ruleInstanceNode : projectNode.get("ruleInstances")) {
                    JsonNode locationNode = ruleInstanceNode.get("location");
                    Path filePath = Paths.get(locationNode.get("path").asText(), new String[0]);
                    acc.addFileResult(acc.getDirectory().resolve(filePath), ruleInstanceNode);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e.getMessage() + "\nupgrade-assistant:\n" + new String(Files.readAllBytes(output)), e);
            }
            catch (IOException ignored) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private Path buildReportPath(UpgradeAssistantRecipe.Accumulator acc, Path solutionFile) {
        String reportName = solutionFile.getFileName().toString().replace(".sln", "-analyze.json");
        return acc.getDirectory().resolve(reportName);
    }

    @Override
    protected SourceFile createAfter(SourceFile before, UpgradeAssistantRecipe.Accumulator acc, ExecutionContext ctx) {
        List<JsonNode> results = acc.getFileResults(acc.resolvedPath(before));
        if (results != null) {
            for (JsonNode ruleInstanceNode : results) {
                this.analysisTable.insertRow(ctx, this.buildUpgradeAssistantAnalysisRow(ruleInstanceNode, acc));
            }
        }
        return super.createAfter(before, acc, ctx);
    }

    private UpgradeAssistantAnalysis.Row buildUpgradeAssistantAnalysisRow(JsonNode ruleInstanceNode, UpgradeAssistantRecipe.Accumulator acc) {
        String recommendation;
        String codeSnippet;
        JsonNode locationNode = ruleInstanceNode.get("location");
        URL link = null;
        if (locationNode.has("links")) {
            try {
                JsonNode linkNode = locationNode.get("links").get(0);
                link = new URL(linkNode.get("url").asText());
            }
            catch (IOException linkNode) {
                // empty catch block
            }
        }
        String projectPath = ruleInstanceNode.get("projectPath").asText();
        String sourcePath = locationNode.get("path").asText();
        String ruleId = ruleInstanceNode.get("ruleId").asText();
        String ruleLabel = acc.getRuleLabel(ruleId);
        String snippet = locationNode.get("snippet").asText();
        Matcher matcher = RECOMMENDATION_SNIPPET_PATTERN.matcher(snippet);
        if (matcher.find()) {
            codeSnippet = matcher.group(1);
            recommendation = matcher.group(2);
        } else {
            matcher = CURRENT_NEW_SNIPPET_PATTERN.matcher(snippet);
            if (matcher.find()) {
                codeSnippet = matcher.group(1);
                recommendation = matcher.group(2);
            } else {
                codeSnippet = snippet;
                recommendation = null;
            }
        }
        return new UpgradeAssistantAnalysis.Row(projectPath, sourcePath, ruleId, ruleLabel, codeSnippet, recommendation, link);
    }

    @Generated
    public UpgradeAssistantAnalyze(String targetFramework, @Nullable String privacyMode) {
        this.targetFramework = targetFramework;
        this.privacyMode = privacyMode;
    }

    @Generated
    public UpgradeAssistantAnalysis getAnalysisTable() {
        return this.analysisTable;
    }

    @Generated
    public String getTargetFramework() {
        return this.targetFramework;
    }

    @Generated
    public @Nullable String getPrivacyMode() {
        return this.privacyMode;
    }

    @Generated
    public String toString() {
        return "UpgradeAssistantAnalyze(analysisTable=" + (Object)((Object)this.getAnalysisTable()) + ", targetFramework=" + this.getTargetFramework() + ", privacyMode=" + this.getPrivacyMode() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeAssistantAnalyze)) {
            return false;
        }
        UpgradeAssistantAnalyze other = (UpgradeAssistantAnalyze)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$targetFramework = this.getTargetFramework();
        String other$targetFramework = other.getTargetFramework();
        if (this$targetFramework == null ? other$targetFramework != null : !this$targetFramework.equals(other$targetFramework)) {
            return false;
        }
        String this$privacyMode = this.getPrivacyMode();
        String other$privacyMode = other.getPrivacyMode();
        return !(this$privacyMode == null ? other$privacyMode != null : !this$privacyMode.equals(other$privacyMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeAssistantAnalyze;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $targetFramework = this.getTargetFramework();
        result = result * 59 + ($targetFramework == null ? 43 : $targetFramework.hashCode());
        String $privacyMode = this.getPrivacyMode();
        result = result * 59 + ($privacyMode == null ? 43 : $privacyMode.hashCode());
        return result;
    }
}

