/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.annotation;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.dropwizard.annotation.AddClassAnnotationVisitor;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class AddClassAnnotationIfAnnotationExists
extends Recipe {
    @Option(displayName="Annotation to add", description="The annotation that should be added.", example="org.springframework.stereotype.Component")
    private final String annotationToAdd;
    @Option(displayName="Target annotation class name", description="The annotation that should looked for.", example="javax.ws.rs.Path")
    private final String targetAnnotationClassName;
    @Option(displayName="Annotate inner classes", description="Boolean whether to annotate inner classes of the matched annotation", required=false)
    private final @Nullable Boolean annotateInnerClasses;

    public String getDisplayName() {
        return "Add annotation if target annotations exist";
    }

    public String getDescription() {
        return "Adds annotation if class has any of the specified target annotations.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AddClassAnnotationVisitor(this.annotationToAdd, this.annotateInnerClasses){

            @Override
            protected boolean shouldAddAnnotation(J.ClassDeclaration cd) {
                return ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor()).stream().anyMatch(annotation -> {
                    JavaType.FullyQualified type = TypeUtils.asFullyQualified((JavaType)annotation.getType());
                    return type != null && AddClassAnnotationIfAnnotationExists.this.targetAnnotationClassName.equals(type.getFullyQualifiedName());
                });
            }
        };
    }

    @Generated
    public AddClassAnnotationIfAnnotationExists(String annotationToAdd, String targetAnnotationClassName, @Nullable Boolean annotateInnerClasses) {
        this.annotationToAdd = annotationToAdd;
        this.targetAnnotationClassName = targetAnnotationClassName;
        this.annotateInnerClasses = annotateInnerClasses;
    }

    @Generated
    public String getAnnotationToAdd() {
        return this.annotationToAdd;
    }

    @Generated
    public String getTargetAnnotationClassName() {
        return this.targetAnnotationClassName;
    }

    @Generated
    public @Nullable Boolean getAnnotateInnerClasses() {
        return this.annotateInnerClasses;
    }

    @Generated
    public String toString() {
        return "AddClassAnnotationIfAnnotationExists(annotationToAdd=" + this.getAnnotationToAdd() + ", targetAnnotationClassName=" + this.getTargetAnnotationClassName() + ", annotateInnerClasses=" + this.getAnnotateInnerClasses() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddClassAnnotationIfAnnotationExists)) {
            return false;
        }
        AddClassAnnotationIfAnnotationExists other = (AddClassAnnotationIfAnnotationExists)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$annotateInnerClasses = this.getAnnotateInnerClasses();
        Boolean other$annotateInnerClasses = other.getAnnotateInnerClasses();
        if (this$annotateInnerClasses == null ? other$annotateInnerClasses != null : !((Object)this$annotateInnerClasses).equals(other$annotateInnerClasses)) {
            return false;
        }
        String this$annotationToAdd = this.getAnnotationToAdd();
        String other$annotationToAdd = other.getAnnotationToAdd();
        if (this$annotationToAdd == null ? other$annotationToAdd != null : !this$annotationToAdd.equals(other$annotationToAdd)) {
            return false;
        }
        String this$targetAnnotationClassName = this.getTargetAnnotationClassName();
        String other$targetAnnotationClassName = other.getTargetAnnotationClassName();
        return !(this$targetAnnotationClassName == null ? other$targetAnnotationClassName != null : !this$targetAnnotationClassName.equals(other$targetAnnotationClassName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddClassAnnotationIfAnnotationExists;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $annotateInnerClasses = this.getAnnotateInnerClasses();
        result = result * 59 + ($annotateInnerClasses == null ? 43 : ((Object)$annotateInnerClasses).hashCode());
        String $annotationToAdd = this.getAnnotationToAdd();
        result = result * 59 + ($annotationToAdd == null ? 43 : $annotationToAdd.hashCode());
        String $targetAnnotationClassName = this.getTargetAnnotationClassName();
        result = result * 59 + ($targetAnnotationClassName == null ? 43 : $targetAnnotationClassName.hashCode());
        return result;
    }
}

