/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.annotation;

import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.dropwizard.annotation.AddClassAnnotationVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class AddClassAnnotationIfSuperTypeExists
extends Recipe {
    @Option(displayName="Annotation to add", description="The annotation that should be added.", example="org.springframework.stereotype.Component")
    private final String annotationToAdd;
    @Option(displayName="Target supertype name", description="The supertype that should looked for.", example="javax.ws.rs.Path")
    private final String targetSupertypeName;
    @Option(displayName="Annotate inner classes", description="Boolean whether to annotate inner classes of the matched annotation", required=false)
    private final @Nullable Boolean annotateInnerClasses;

    public String getDisplayName() {
        return "Add annotation if target supertypes exist";
    }

    public String getDescription() {
        return "Adds annotation if class extends or implements any of the specified target types.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AddClassAnnotationVisitor(this.annotationToAdd, this.annotateInnerClasses){

            @Override
            protected boolean shouldAddAnnotation(J.ClassDeclaration cd) {
                JavaType.FullyQualified extendsType;
                if (cd.getExtends() != null && (extendsType = TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType())) != null && AddClassAnnotationIfSuperTypeExists.this.targetSupertypeName.equals(extendsType.getFullyQualifiedName())) {
                    return true;
                }
                if (cd.getImplements() != null) {
                    return cd.getImplements().stream().map(impl -> TypeUtils.asFullyQualified((JavaType)impl.getType())).filter(Objects::nonNull).anyMatch(type -> AddClassAnnotationIfSuperTypeExists.this.targetSupertypeName.equals(type.getFullyQualifiedName()));
                }
                return false;
            }
        };
    }

    @Generated
    public AddClassAnnotationIfSuperTypeExists(String annotationToAdd, String targetSupertypeName, @Nullable Boolean annotateInnerClasses) {
        this.annotationToAdd = annotationToAdd;
        this.targetSupertypeName = targetSupertypeName;
        this.annotateInnerClasses = annotateInnerClasses;
    }

    @Generated
    public String getAnnotationToAdd() {
        return this.annotationToAdd;
    }

    @Generated
    public String getTargetSupertypeName() {
        return this.targetSupertypeName;
    }

    @Generated
    public @Nullable Boolean getAnnotateInnerClasses() {
        return this.annotateInnerClasses;
    }

    @Generated
    public String toString() {
        return "AddClassAnnotationIfSuperTypeExists(annotationToAdd=" + this.getAnnotationToAdd() + ", targetSupertypeName=" + this.getTargetSupertypeName() + ", annotateInnerClasses=" + this.getAnnotateInnerClasses() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddClassAnnotationIfSuperTypeExists)) {
            return false;
        }
        AddClassAnnotationIfSuperTypeExists other = (AddClassAnnotationIfSuperTypeExists)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$annotateInnerClasses = this.getAnnotateInnerClasses();
        Boolean other$annotateInnerClasses = other.getAnnotateInnerClasses();
        if (this$annotateInnerClasses == null ? other$annotateInnerClasses != null : !((Object)this$annotateInnerClasses).equals(other$annotateInnerClasses)) {
            return false;
        }
        String this$annotationToAdd = this.getAnnotationToAdd();
        String other$annotationToAdd = other.getAnnotationToAdd();
        if (this$annotationToAdd == null ? other$annotationToAdd != null : !this$annotationToAdd.equals(other$annotationToAdd)) {
            return false;
        }
        String this$targetSupertypeName = this.getTargetSupertypeName();
        String other$targetSupertypeName = other.getTargetSupertypeName();
        return !(this$targetSupertypeName == null ? other$targetSupertypeName != null : !this$targetSupertypeName.equals(other$targetSupertypeName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddClassAnnotationIfSuperTypeExists;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $annotateInnerClasses = this.getAnnotateInnerClasses();
        result = result * 59 + ($annotateInnerClasses == null ? 43 : ((Object)$annotateInnerClasses).hashCode());
        String $annotationToAdd = this.getAnnotationToAdd();
        result = result * 59 + ($annotationToAdd == null ? 43 : $annotationToAdd.hashCode());
        String $targetSupertypeName = this.getTargetSupertypeName();
        result = result * 59 + ($targetSupertypeName == null ? 43 : $targetSupertypeName.hashCode());
        return result;
    }
}

