/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.annotation;

import java.util.Collection;
import java.util.Comparator;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.service.ImportService;
import org.openrewrite.java.tree.J;

public abstract class AddClassAnnotationVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private final String annotationText;
    private final Boolean annotateSubclasses;

    protected abstract boolean shouldAddAnnotation(J.ClassDeclaration var1);

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
        J.ClassDeclaration cd = super.visitClassDeclaration(classDeclaration, (Object)ctx);
        String annotationType = this.annotationText.split("[(<]")[0].trim();
        if (((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), new AnnotationMatcher(annotationType))) {
            return cd;
        }
        boolean shouldAdd = this.shouldAddAnnotation(cd);
        if (!shouldAdd && Boolean.TRUE.equals(this.annotateSubclasses)) {
            shouldAdd = this.shouldAddAnnotationToAnyParentClass();
        }
        if (!shouldAdd) {
            return cd;
        }
        this.maybeAddImport(annotationType);
        J.ClassDeclaration updated = (J.ClassDeclaration)JavaTemplate.builder((String)"@#{}").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).imports(new String[]{annotationType}).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[]{this.annotationText});
        this.doAfterVisit((TreeVisitor)((ImportService)this.service(ImportService.class)).shortenFullyQualifiedTypeReferencesIn((J)updated));
        return (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)updated, ctx);
    }

    private boolean shouldAddAnnotationToAnyParentClass() {
        Cursor cursor = this.getCursor();
        do {
            if ((cursor = cursor.getParent()) != null) continue;
            return false;
        } while (!(cursor.getValue() instanceof J.ClassDeclaration) || !this.shouldAddAnnotation((J.ClassDeclaration)cursor.getValue()));
        return true;
    }

    @Generated
    public AddClassAnnotationVisitor(String annotationText, Boolean annotateSubclasses) {
        this.annotationText = annotationText;
        this.annotateSubclasses = annotateSubclasses;
    }
}

