/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.config;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.maven.ExcludeDependency;
import org.openrewrite.maven.RemoveDependency;

public final class RemoveAndExcludeDependency
extends Recipe {
    @Option(displayName="Group ID to remove", description="The first part of a dependency coordinate to remove 'org.mockito'", example="org.mockito")
    private final String groupId;
    @Option(displayName="Artifact ID to remove", description="The second part of a dependency coordinate to remove 'mockito-core'", example="mockito-core")
    private final String artifactId;

    public String getDisplayName() {
        return "Combined dependency management to remove and exclude";
    }

    public String getDescription() {
        return "Combines excluding transitive dependencies and removing direct dependencies.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new RemoveDependency(this.groupId, this.artifactId, null), new ExcludeDependency(this.groupId, this.artifactId, null));
    }

    @Generated
    public RemoveAndExcludeDependency(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String toString() {
        return "RemoveAndExcludeDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveAndExcludeDependency)) {
            return false;
        }
        RemoveAndExcludeDependency other = (RemoveAndExcludeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveAndExcludeDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }
}

