/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.general;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public final class RemoveMethodsByPackage
extends Recipe {
    @Option(displayName="Package filter", description="The package name to filter methods by. Methods with return types or parameter types in this package (or subpackages) will be removed.", example="com.example.unwanted")
    private final String packageFilter;

    public String getDisplayName() {
        return "Remove methods referencing specified package";
    }

    public String getDescription() {
        return "Removes any method that has a return type or parameter type from the specified package.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (method.getReturnTypeExpression() != null) {
                    JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)method.getReturnTypeExpression().getType());
                    if (fq != null && fq.getFullyQualifiedName().startsWith(RemoveMethodsByPackage.this.packageFilter)) {
                        this.maybeRemoveImport(fq);
                        return null;
                    }
                    String returnTypeStr = method.getReturnTypeExpression().toString();
                    if (returnTypeStr.startsWith(RemoveMethodsByPackage.this.packageFilter)) {
                        this.maybeRemoveImport(returnTypeStr);
                        return null;
                    }
                }
                for (Statement param : method.getParameters()) {
                    if (!(param instanceof J.VariableDeclarations)) continue;
                    for (J.VariableDeclarations.NamedVariable namedVar : ((J.VariableDeclarations)param).getVariables()) {
                        JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)namedVar.getType());
                        if (fq == null || !fq.getFullyQualifiedName().startsWith(RemoveMethodsByPackage.this.packageFilter)) continue;
                        this.maybeRemoveImport(fq);
                        return null;
                    }
                }
                return m;
            }
        };
    }

    @Generated
    public RemoveMethodsByPackage(String packageFilter) {
        this.packageFilter = packageFilter;
    }

    @Generated
    public String getPackageFilter() {
        return this.packageFilter;
    }

    @Generated
    public String toString() {
        return "RemoveMethodsByPackage(packageFilter=" + this.getPackageFilter() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveMethodsByPackage)) {
            return false;
        }
        RemoveMethodsByPackage other = (RemoveMethodsByPackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$packageFilter = this.getPackageFilter();
        String other$packageFilter = other.getPackageFilter();
        return !(this$packageFilter == null ? other$packageFilter != null : !this$packageFilter.equals(other$packageFilter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveMethodsByPackage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packageFilter = this.getPackageFilter();
        result = result * 59 + ($packageFilter == null ? 43 : $packageFilter.hashCode());
        return result;
    }
}

