/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.general;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class RemoveVariablesByPackage
extends Recipe {
    @Option(displayName="Package filter", description="The package name to filter methods by. Methods with return types or parameter types in this package (or subpackages) will be removed.", example="com.example.unwanted")
    private final String packageFilter;
    @Option(displayName="Remove only class scope", description="Ignores variables that are method scope", example="com.example.unwanted")
    private final Boolean removeOnlyClassScope;

    public String getDisplayName() {
        return "Remove class variables matching package filter";
    }

    public String getDescription() {
        return "Removes class-level variables from classes in the specified package.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations vd = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (this.isMethodParameter()) {
                    return vd;
                }
                if (RemoveVariablesByPackage.this.removeOnlyClassScope.booleanValue() && !this.isClassScope()) {
                    return vd;
                }
                for (J.VariableDeclarations.NamedVariable var : vd.getVariables()) {
                    JavaType.Method methodType;
                    if (!(var.getInitializer() instanceof J.MethodInvocation) || (methodType = ((J.MethodInvocation)var.getInitializer()).getMethodType()) == null || !methodType.getDeclaringType().getFullyQualifiedName().contains(RemoveVariablesByPackage.this.packageFilter)) continue;
                    this.doAfterVisit((TreeVisitor)new RemoveImportsVisitor());
                    return null;
                }
                JavaType.FullyQualified declaredFqn = this.resolveFullyQualified(vd.getType());
                if (declaredFqn != null && declaredFqn.getFullyQualifiedName().contains(RemoveVariablesByPackage.this.packageFilter)) {
                    this.doAfterVisit((TreeVisitor)new RemoveImportsVisitor());
                    return null;
                }
                for (J.VariableDeclarations.NamedVariable var : vd.getVariables()) {
                    JavaType.FullyQualified initFqn;
                    if (var.getInitializer() == null || (initFqn = this.resolveFullyQualified(var.getInitializer().getType())) == null || !initFqn.getFullyQualifiedName().contains(RemoveVariablesByPackage.this.packageFilter)) continue;
                    this.doAfterVisit((TreeVisitor)new RemoveImportsVisitor());
                    return null;
                }
                return vd;
            }

            private JavaType.FullyQualified resolveFullyQualified(JavaType type) {
                if (type instanceof JavaType.Parameterized) {
                    return TypeUtils.asFullyQualified((JavaType)((JavaType.Parameterized)type).getType());
                }
                if (type instanceof JavaType.Class) {
                    return TypeUtils.asFullyQualified((JavaType)type);
                }
                return null;
            }

            private boolean isClassScope() {
                return this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.ClassDeclaration;
            }

            private boolean isMethodParameter() {
                return this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.MethodDeclaration;
            }
        };
    }

    @Generated
    public RemoveVariablesByPackage(String packageFilter, Boolean removeOnlyClassScope) {
        this.packageFilter = packageFilter;
        this.removeOnlyClassScope = removeOnlyClassScope;
    }

    @Generated
    public String getPackageFilter() {
        return this.packageFilter;
    }

    @Generated
    public Boolean getRemoveOnlyClassScope() {
        return this.removeOnlyClassScope;
    }

    @Generated
    public String toString() {
        return "RemoveVariablesByPackage(packageFilter=" + this.getPackageFilter() + ", removeOnlyClassScope=" + this.getRemoveOnlyClassScope() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveVariablesByPackage)) {
            return false;
        }
        RemoveVariablesByPackage other = (RemoveVariablesByPackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$removeOnlyClassScope = this.getRemoveOnlyClassScope();
        Boolean other$removeOnlyClassScope = other.getRemoveOnlyClassScope();
        if (this$removeOnlyClassScope == null ? other$removeOnlyClassScope != null : !((Object)this$removeOnlyClassScope).equals(other$removeOnlyClassScope)) {
            return false;
        }
        String this$packageFilter = this.getPackageFilter();
        String other$packageFilter = other.getPackageFilter();
        return !(this$packageFilter == null ? other$packageFilter != null : !this$packageFilter.equals(other$packageFilter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveVariablesByPackage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $removeOnlyClassScope = this.getRemoveOnlyClassScope();
        result = result * 59 + ($removeOnlyClassScope == null ? 43 : ((Object)$removeOnlyClassScope).hashCode());
        String $packageFilter = this.getPackageFilter();
        result = result * 59 + ($packageFilter == null ? 43 : $packageFilter.hashCode());
        return result;
    }

    static class RemoveImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        RemoveImportsVisitor() {
        }

        public J.Import visitImport(J.Import _import, ExecutionContext ctx) {
            J.Import imp = super.visitImport(_import, (Object)ctx);
            this.maybeRemoveImport(imp.getQualid().toString());
            return imp;
        }
    }
}

