/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.method;

import java.util.Collection;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.dropwizard.method.RemoveUnnecessaryOverride;
import org.openrewrite.java.dropwizard.method.RemoveUnnecessarySuperCalls;
import org.openrewrite.java.dropwizard.method.UpdateMethodTypesVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public final class ChangeSuperType
extends Recipe {
    @Option(displayName="Target class", description="The fully qualified name of the class whose superclass should be changed.", example="com.myorg.MyClass")
    private final String targetClass;
    @Option(displayName="New superclass", description="The fully qualified name of the new superclass to extend or interface to implement.", example="com.myorg.NewSuperclass")
    private final String newSuperclass;
    @Option(displayName="Keep type parameters", description="Whether to keep existing type parameters on the target class declaration.", required=false)
    private final Boolean keepTypeParameters;
    @Option(displayName="Convert to interface", description="If the new supertype is an interface, setting this to true converts 'extends' to 'implements'.", required=false)
    private final Boolean convertToInterface;
    @Option(displayName="Remove unnecessary overrides", description="Remove method Override annotations that override methods from the *old* superclass but are no longer necessary with the new superclass.", required=false)
    private final Boolean removeUnnecessaryOverrides;

    public String getDisplayName() {
        return "Change superclass";
    }

    public String getDescription() {
        return "Changes the superclass of a specified class to a new superclass.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                JavaType.FullyQualified newSuperType;
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getExtends() == null || !TypeUtils.isOfClassType((JavaType)cd.getExtends().getType(), (String)ChangeSuperType.this.targetClass)) {
                    return cd;
                }
                String typeParams = this.getTypeParams(cd.getExtends());
                this.maybeAddImport(ChangeSuperType.this.newSuperclass);
                this.maybeRemoveImport(ChangeSuperType.this.targetClass);
                JavaTemplate extendsTemplate = JavaTemplate.builder((String)(ChangeSuperType.this.newSuperclass + typeParams)).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).imports(new String[]{ChangeSuperType.this.newSuperclass}).contextSensitive().build();
                if (Boolean.TRUE.equals(ChangeSuperType.this.convertToInterface)) {
                    cd = (J.ClassDeclaration)extendsTemplate.apply(this.updateCursor((Tree)cd), cd.getCoordinates().addImplementsClause(), new Object[0]);
                    cd = cd.withExtends(null);
                    TypeTree lastInterface = (TypeTree)cd.getImplements().get(cd.getImplements().size() - 1);
                    newSuperType = TypeUtils.asFullyQualified((JavaType)lastInterface.getType());
                } else {
                    cd = (J.ClassDeclaration)extendsTemplate.apply(this.updateCursor((Tree)cd), cd.getCoordinates().replaceExtendsClause(), new Object[0]);
                    newSuperType = TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType());
                }
                if (newSuperType == null) {
                    newSuperType = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)ChangeSuperType.this.newSuperclass));
                }
                cd = cd.withType((JavaType)((JavaType.Class)cd.getType()).withSupertype(newSuperType));
                this.doAfterVisit((TreeVisitor)ShortenFullyQualifiedTypeReferences.modifyOnly((J)cd));
                this.doAfterVisit((TreeVisitor)new UpdateMethodTypesVisitor(cd.getType()));
                if (Boolean.TRUE.equals(ChangeSuperType.this.removeUnnecessaryOverrides)) {
                    this.doAfterVisit(new RemoveUnnecessaryOverride(false).getVisitor());
                }
                this.doAfterVisit((TreeVisitor)new RemoveUnnecessarySuperCalls.RemoveUnnecessarySuperCallsVisitor());
                return cd;
            }

            private String getTypeParams(TypeTree extendsType) {
                StringBuilder typeParams = new StringBuilder();
                if (Boolean.TRUE.equals(ChangeSuperType.this.keepTypeParameters) && extendsType instanceof J.ParameterizedType) {
                    J.ParameterizedType parameterizedType = (J.ParameterizedType)extendsType;
                    boolean hasParameters = false;
                    typeParams.append('<');
                    for (Expression typeParameter : parameterizedType.getTypeParameters()) {
                        if (hasParameters) {
                            typeParams.append(", ");
                        }
                        typeParams.append(typeParameter.toString());
                        hasParameters = true;
                    }
                    if (hasParameters) {
                        typeParams.append('>');
                    } else {
                        typeParams.setLength(0);
                    }
                }
                return typeParams.toString();
            }
        };
    }

    @Generated
    public ChangeSuperType(String targetClass, String newSuperclass, Boolean keepTypeParameters, Boolean convertToInterface, Boolean removeUnnecessaryOverrides) {
        this.targetClass = targetClass;
        this.newSuperclass = newSuperclass;
        this.keepTypeParameters = keepTypeParameters;
        this.convertToInterface = convertToInterface;
        this.removeUnnecessaryOverrides = removeUnnecessaryOverrides;
    }

    @Generated
    public String getTargetClass() {
        return this.targetClass;
    }

    @Generated
    public String getNewSuperclass() {
        return this.newSuperclass;
    }

    @Generated
    public Boolean getKeepTypeParameters() {
        return this.keepTypeParameters;
    }

    @Generated
    public Boolean getConvertToInterface() {
        return this.convertToInterface;
    }

    @Generated
    public Boolean getRemoveUnnecessaryOverrides() {
        return this.removeUnnecessaryOverrides;
    }

    @Generated
    public String toString() {
        return "ChangeSuperType(targetClass=" + this.getTargetClass() + ", newSuperclass=" + this.getNewSuperclass() + ", keepTypeParameters=" + this.getKeepTypeParameters() + ", convertToInterface=" + this.getConvertToInterface() + ", removeUnnecessaryOverrides=" + this.getRemoveUnnecessaryOverrides() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeSuperType)) {
            return false;
        }
        ChangeSuperType other = (ChangeSuperType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$keepTypeParameters = this.getKeepTypeParameters();
        Boolean other$keepTypeParameters = other.getKeepTypeParameters();
        if (this$keepTypeParameters == null ? other$keepTypeParameters != null : !((Object)this$keepTypeParameters).equals(other$keepTypeParameters)) {
            return false;
        }
        Boolean this$convertToInterface = this.getConvertToInterface();
        Boolean other$convertToInterface = other.getConvertToInterface();
        if (this$convertToInterface == null ? other$convertToInterface != null : !((Object)this$convertToInterface).equals(other$convertToInterface)) {
            return false;
        }
        Boolean this$removeUnnecessaryOverrides = this.getRemoveUnnecessaryOverrides();
        Boolean other$removeUnnecessaryOverrides = other.getRemoveUnnecessaryOverrides();
        if (this$removeUnnecessaryOverrides == null ? other$removeUnnecessaryOverrides != null : !((Object)this$removeUnnecessaryOverrides).equals(other$removeUnnecessaryOverrides)) {
            return false;
        }
        String this$targetClass = this.getTargetClass();
        String other$targetClass = other.getTargetClass();
        if (this$targetClass == null ? other$targetClass != null : !this$targetClass.equals(other$targetClass)) {
            return false;
        }
        String this$newSuperclass = this.getNewSuperclass();
        String other$newSuperclass = other.getNewSuperclass();
        return !(this$newSuperclass == null ? other$newSuperclass != null : !this$newSuperclass.equals(other$newSuperclass));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeSuperType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $keepTypeParameters = this.getKeepTypeParameters();
        result = result * 59 + ($keepTypeParameters == null ? 43 : ((Object)$keepTypeParameters).hashCode());
        Boolean $convertToInterface = this.getConvertToInterface();
        result = result * 59 + ($convertToInterface == null ? 43 : ((Object)$convertToInterface).hashCode());
        Boolean $removeUnnecessaryOverrides = this.getRemoveUnnecessaryOverrides();
        result = result * 59 + ($removeUnnecessaryOverrides == null ? 43 : ((Object)$removeUnnecessaryOverrides).hashCode());
        String $targetClass = this.getTargetClass();
        result = result * 59 + ($targetClass == null ? 43 : $targetClass.hashCode());
        String $newSuperclass = this.getNewSuperclass();
        result = result * 59 + ($newSuperclass == null ? 43 : $newSuperclass.hashCode());
        return result;
    }
}

