/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.method;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.dropwizard.method.RemoveUnnecessarySuperCalls;
import org.openrewrite.java.dropwizard.method.UpdateMethodTypesVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class RemoveSuperTypeByType
extends Recipe {
    @Option(displayName="Fully qualified name of the superclass to remove", description="Supertypes that match this name are to be removed", example="io.dropwizard.Configuration")
    private final String typeToRemove;

    public String getDisplayName() {
        return "Remove supertype by fully qualified name matches";
    }

    public String getDescription() {
        return "Removes a specified type from class extends or implements clauses.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(this.typeToRemove, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getExtends() != null && TypeUtils.isOfClassType((JavaType)cd.getExtends().getType(), (String)RemoveSuperTypeByType.this.typeToRemove)) {
                    cd = cd.withExtends(null);
                    JavaType.ShallowClass type = (JavaType.ShallowClass)JavaType.buildType((String)"java.lang.Object");
                    this.doAfterVisit((TreeVisitor)new UpdateMethodTypesVisitor((JavaType.FullyQualified)type));
                    this.doAfterVisit((TreeVisitor)new RemoveUnnecessarySuperCalls.RemoveUnnecessarySuperCallsVisitor());
                }
                return cd;
            }
        });
    }

    @Generated
    public RemoveSuperTypeByType(String typeToRemove) {
        this.typeToRemove = typeToRemove;
    }

    @Generated
    public String getTypeToRemove() {
        return this.typeToRemove;
    }

    @Generated
    public String toString() {
        return "RemoveSuperTypeByType(typeToRemove=" + this.getTypeToRemove() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveSuperTypeByType)) {
            return false;
        }
        RemoveSuperTypeByType other = (RemoveSuperTypeByType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$typeToRemove = this.getTypeToRemove();
        String other$typeToRemove = other.getTypeToRemove();
        return !(this$typeToRemove == null ? other$typeToRemove != null : !this$typeToRemove.equals(other$typeToRemove));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveSuperTypeByType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeToRemove = this.getTypeToRemove();
        result = result * 59 + ($typeToRemove == null ? 43 : $typeToRemove.hashCode());
        return result;
    }
}

