/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.method;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class RemoveUnnecessaryOverride
extends Recipe {
    private static final AnnotationMatcher OVERRIDE_ANNOTATION = new AnnotationMatcher("@java.lang.Override");
    private static final RemoveAnnotationVisitor removeAnnotationVisitor = new RemoveAnnotationVisitor(OVERRIDE_ANNOTATION);
    @Option(displayName="Ignore methods in anonymous classes", description="When enabled, ignore @Override annotations on methods in anonymous classes.", required=false)
    private final @Nullable Boolean ignoreAnonymousClassMethods;

    public String getDisplayName() {
        return "Remove unnecessary `@Override` annotations";
    }

    public String getDescription() {
        return "Removes `@Override` annotations from methods that don't actually override or implement any method. This helps maintain clean code by removing incorrect annotations that could be misleading.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.lang.Override", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            private Cursor getCursorToParentScope(Cursor cursor) {
                return cursor.dropParentUntil(is -> is instanceof J.NewClass || is instanceof J.ClassDeclaration);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (!(m.isConstructor() || !((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), OVERRIDE_ANNOTATION) || TypeUtils.isOverride((JavaType.Method)m.getMethodType()) || Boolean.TRUE.equals(RemoveUnnecessaryOverride.this.ignoreAnonymousClassMethods) && this.getCursorToParentScope(this.getCursor()).getValue() instanceof J.NewClass)) {
                    return removeAnnotationVisitor.visitMethodDeclaration(m, ctx);
                }
                return m;
            }
        });
    }

    @Generated
    public RemoveUnnecessaryOverride(@Nullable Boolean ignoreAnonymousClassMethods) {
        this.ignoreAnonymousClassMethods = ignoreAnonymousClassMethods;
    }

    @Generated
    public @Nullable Boolean getIgnoreAnonymousClassMethods() {
        return this.ignoreAnonymousClassMethods;
    }

    @Generated
    public String toString() {
        return "RemoveUnnecessaryOverride(ignoreAnonymousClassMethods=" + this.getIgnoreAnonymousClassMethods() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveUnnecessaryOverride)) {
            return false;
        }
        RemoveUnnecessaryOverride other = (RemoveUnnecessaryOverride)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ignoreAnonymousClassMethods = this.getIgnoreAnonymousClassMethods();
        Boolean other$ignoreAnonymousClassMethods = other.getIgnoreAnonymousClassMethods();
        return !(this$ignoreAnonymousClassMethods == null ? other$ignoreAnonymousClassMethods != null : !((Object)this$ignoreAnonymousClassMethods).equals(other$ignoreAnonymousClassMethods));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveUnnecessaryOverride;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreAnonymousClassMethods = this.getIgnoreAnonymousClassMethods();
        result = result * 59 + ($ignoreAnonymousClassMethods == null ? 43 : ((Object)$ignoreAnonymousClassMethods).hashCode());
        return result;
    }
}

