/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.method;

import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveUnnecessarySuperCalls
extends Recipe {
    public String getDisplayName() {
        return "Remove `super` calls when the class does not extend another class";
    }

    public String getDescription() {
        return "Removes calls to `super(...)` or `super.someMethod(...)` if the class does not have a real superclass besides `java.lang.Object`.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new RemoveUnnecessarySuperCallsVisitor();
    }

    public static class RemoveUnnecessarySuperCallsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.ClassDeclaration classDecl;
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (this.isSuperCall(mi) && (classDecl = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class)) != null) {
                if (!this.hasRealSuperclass(classDecl)) {
                    return null;
                }
                if (!TypeUtils.isOverride((JavaType.Method)mi.getMethodType())) {
                    return null;
                }
            }
            return mi;
        }

        private boolean isSuperCall(J.MethodInvocation mi) {
            if (mi.getSelect() instanceof J.Identifier) {
                return "super".equals(((J.Identifier)mi.getSelect()).getSimpleName());
            }
            return mi.getSelect() == null && "super".equals(mi.getSimpleName());
        }

        private boolean hasRealSuperclass(J.ClassDeclaration classDecl) {
            if (classDecl.getExtends() == null) {
                return false;
            }
            JavaType.FullyQualified fqClassType = TypeUtils.asFullyQualified((JavaType)classDecl.getType());
            if (fqClassType == null) {
                return true;
            }
            JavaType.FullyQualified fqSuperType = TypeUtils.asFullyQualified((JavaType)fqClassType.getSupertype());
            if (fqSuperType == null) {
                return false;
            }
            return !"java.lang.Object".equals(fqSuperType.getFullyQualifiedName());
        }
    }
}

