/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dropwizard.method;

import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class UpdateMethodTypesVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private final JavaType.FullyQualified newSuperclass;

    public UpdateMethodTypesVisitor(JavaType.FullyQualified newSuperclass) {
        this.newSuperclass = newSuperclass;
    }

    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
        JavaType.FullyQualified declaringType;
        boolean hasOverrideAnnotation;
        JavaType.Method methodType = method.getMethodType();
        if (methodType != null && (hasOverrideAnnotation = method.getLeadingAnnotations().stream().anyMatch(annotation -> "Override".equals(annotation.getSimpleName()))) && (declaringType = methodType.getDeclaringType()) != null) {
            JavaType.Method originalMethodType = method.getMethodType();
            if (originalMethodType != null) {
                JavaType.Method newMethodType = originalMethodType.withDeclaringType(this.newSuperclass);
                method = method.withMethodType(newMethodType);
                method = method.withName(method.getName().withType((JavaType)newMethodType));
            }
            return method;
        }
        return method;
    }
}

