/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.featureflags.launchdarkly;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.featureflags.RemoveBooleanFlag;

public final class RemoveBoolVariation
extends Recipe {
    @Option(displayName="Feature flag key", description="The key of the feature flag to remove.", example="flag-key-123abc")
    private final String featureKey;
    @Option(displayName="Replacement value", description="The value to replace the feature flag check with.", example="true")
    private final Boolean replacementValue;

    public String getDisplayName() {
        return "Remove LaunchDarkly's `boolVariation` for feature key";
    }

    public String getDescription() {
        return "Replace `boolVariation` invocations for feature key with value, and simplify constant if branch execution.";
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new RemoveBooleanFlag("com.launchdarkly.sdk.server.LDClient boolVariation(String, com.launchdarkly.sdk.*, boolean)", this.featureKey, this.replacementValue));
    }

    @Generated
    public RemoveBoolVariation(String featureKey, Boolean replacementValue) {
        this.featureKey = featureKey;
        this.replacementValue = replacementValue;
    }

    @Generated
    public String getFeatureKey() {
        return this.featureKey;
    }

    @Generated
    public Boolean getReplacementValue() {
        return this.replacementValue;
    }

    @Generated
    public String toString() {
        return "RemoveBoolVariation(featureKey=" + this.getFeatureKey() + ", replacementValue=" + this.getReplacementValue() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveBoolVariation)) {
            return false;
        }
        RemoveBoolVariation other = (RemoveBoolVariation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$replacementValue = this.getReplacementValue();
        Boolean other$replacementValue = other.getReplacementValue();
        if (this$replacementValue == null ? other$replacementValue != null : !((Object)this$replacementValue).equals(other$replacementValue)) {
            return false;
        }
        String this$featureKey = this.getFeatureKey();
        String other$featureKey = other.getFeatureKey();
        return !(this$featureKey == null ? other$featureKey != null : !this$featureKey.equals(other$featureKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveBoolVariation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $replacementValue = this.getReplacementValue();
        result = result * 59 + ($replacementValue == null ? 43 : ((Object)$replacementValue).hashCode());
        String $featureKey = this.getFeatureKey();
        result = result * 59 + ($featureKey == null ? 43 : $featureKey.hashCode());
        return result;
    }
}

