/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.github.security.YamlHelper;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ExcessivePermissionsRecipe
extends Recipe {
    private static final Set<String> HIGH_RISK_PERMISSIONS = new HashSet<String>(Arrays.asList("actions", "attestations", "contents", "deployments", "id-token", "issues", "packages", "pages", "pull-requests"));
    private static final Set<String> MEDIUM_RISK_PERMISSIONS = new HashSet<String>(Arrays.asList("checks", "discussions", "repository-projects", "security-events"));

    public String getDisplayName() {
        return "Find excessive permissions";
    }

    public String getDescription() {
        return "Find overly broad permissions in GitHub Actions workflows. Flags 'write-all' permissions and excessive write permissions that could be scoped more narrowly for security. Based on [zizmor's excessive-permissions audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/excessive_permissions.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new ExcessivePermissionsVisitor());
    }

    @Generated
    public ExcessivePermissionsRecipe() {
    }

    @Generated
    public String toString() {
        return "ExcessivePermissionsRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcessivePermissionsRecipe)) {
            return false;
        }
        ExcessivePermissionsRecipe other = (ExcessivePermissionsRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExcessivePermissionsRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class ExcessivePermissionsVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private ExcessivePermissionsVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isPermissionsEntry(mappingEntry)) {
                return this.checkPermissions(mappingEntry);
            }
            return mappingEntry;
        }

        private boolean isPermissionsEntry(Yaml.Mapping.Entry entry) {
            return "permissions".equals(entry.getKey().getValue());
        }

        private Yaml.Mapping.Entry checkPermissions(Yaml.Mapping.Entry entry) {
            String scalarPermissionValue = YamlHelper.getScalarValue(entry.getValue());
            if (scalarPermissionValue != null) {
                return this.checkScalarPermissions(entry, scalarPermissionValue);
            }
            if (entry.getValue() instanceof Yaml.Mapping) {
                return this.checkMappingPermissions(entry, (Yaml.Mapping)entry.getValue());
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkScalarPermissions(Yaml.Mapping.Entry entry, String permissionValue) {
            switch (permissionValue) {
                case "write-all": {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uses 'write-all' permissions which grants excessive access. Consider using specific permissions instead.");
                }
                case "read-all": {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Uses 'read-all' permissions. Consider using specific permissions if only certain resources need to be accessed.");
                }
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkMappingPermissions(Yaml.Mapping.Entry entry, Yaml.Mapping permissionsMapping) {
            ArrayList<String> issues = new ArrayList<String>();
            for (Yaml.Mapping.Entry permEntry : permissionsMapping.getEntries()) {
                String permissionName = permEntry.getKey().getValue();
                String permissionValue = YamlHelper.getScalarValue(permEntry.getValue());
                if (permissionName == null || permissionValue == null || !"write".equals(permissionValue)) continue;
                if (HIGH_RISK_PERMISSIONS.contains(permissionName)) {
                    issues.add(permissionName + ": write (high risk)");
                    continue;
                }
                if (!MEDIUM_RISK_PERMISSIONS.contains(permissionName)) continue;
                issues.add(permissionName + ": write (medium risk)");
            }
            if (!issues.isEmpty()) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)("Contains potentially excessive write permissions: " + String.join((CharSequence)", ", issues) + ". Consider whether these permissions are necessary and if they can be scoped more narrowly."));
            }
            return entry;
        }
    }
}

