/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gitlab;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.yaml.ChangeValue;

public final class ChangeTemplate
extends Recipe {
    @Option(displayName="Template", description="The name of the template to match.", example="Terraform/Base.gitlab-ci.yml")
    private final String oldTemplate;
    @Option(displayName="Template", description="Name of the template to use instead.", example="OpenTofu/Base.gitlab-ci.yml")
    private final String newTemplate;

    public String getDisplayName() {
        return "Change GitLab template";
    }

    public String getDescription() {
        return "Change a GitLab template in use.";
    }

    public List<Recipe> getRecipeList() {
        return Collections.singletonList(new ChangeValue("$.include[?(@.template =~ '" + this.oldTemplate + "(?:@.+)?')].template", this.newTemplate, ".gitlab-ci.yml"));
    }

    @Generated
    public ChangeTemplate(String oldTemplate, String newTemplate) {
        this.oldTemplate = oldTemplate;
        this.newTemplate = newTemplate;
    }

    @Generated
    public String getOldTemplate() {
        return this.oldTemplate;
    }

    @Generated
    public String getNewTemplate() {
        return this.newTemplate;
    }

    @Generated
    public String toString() {
        return "ChangeTemplate(oldTemplate=" + this.getOldTemplate() + ", newTemplate=" + this.getNewTemplate() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTemplate)) {
            return false;
        }
        ChangeTemplate other = (ChangeTemplate)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldTemplate = this.getOldTemplate();
        String other$oldTemplate = other.getOldTemplate();
        if (this$oldTemplate == null ? other$oldTemplate != null : !this$oldTemplate.equals(other$oldTemplate)) {
            return false;
        }
        String this$newTemplate = this.getNewTemplate();
        String other$newTemplate = other.getNewTemplate();
        return !(this$newTemplate == null ? other$newTemplate != null : !this$newTemplate.equals(other$newTemplate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldTemplate = this.getOldTemplate();
        result = result * 59 + ($oldTemplate == null ? 43 : $oldTemplate.hashCode());
        String $newTemplate = this.getNewTemplate();
        result = result * 59 + ($newTemplate == null ? 43 : $newTemplate.hashCode());
        return result;
    }
}

