/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class TypeAnnotationParameter
extends Recipe {
    private static final String ORG_HIBERNATE_ANNOTATIONS_TYPE = "org.hibernate.annotations.Type";
    private static final AnnotationMatcher FQN_TYPE_ANNOTATION = new AnnotationMatcher("@org.hibernate.annotations.Type");
    private static final String ORG_HIBERNATE_ANNOTATIONS_TYPEDEF = "org.hibernate.annotations.TypeDef";
    private static final AnnotationMatcher FQN_TYPEDEF_ANNOTATION = new AnnotationMatcher("@org.hibernate.annotations.TypeDef");
    private static final Set<String> REMOVED_FQNS = new HashSet<String>(Arrays.asList("org.hibernate.type.EnumType", "org.hibernate.type.SerializableType", "org.hibernate.type.SerializableToBlobType", "org.hibernate.type.TextType"));

    public String getDisplayName() {
        return "`@Type` annotation type parameter migration";
    }

    public String getDescription() {
        return "Hibernate 6.x has 'type' parameter of type String replaced with 'value' of type class.";
    }

    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> visitor = new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
                if (FQN_TYPEDEF_ANNOTATION.matches(a)) {
                    Expression name = this.getAttributeValue(annotation, "name");
                    if (name instanceof J.Literal) {
                        String alias = (String)((J.Literal)name).getValue();
                        Expression typeClass = this.getAttributeValue(annotation, "typeClass");
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, alias, (Object)typeClass);
                    }
                    this.maybeRemoveImport(TypeAnnotationParameter.ORG_HIBERNATE_ANNOTATIONS_TYPEDEF);
                    return null;
                }
                if (!FQN_TYPE_ANNOTATION.matches(a)) {
                    return a;
                }
                if (a.getArguments() != null && a.getArguments().stream().anyMatch(arg -> {
                    J.Assignment assignment;
                    if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && "type".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && assignment.getAssignment() instanceof J.Literal) {
                        String fqTypeName = (String)((J.Literal)assignment.getAssignment()).getValue();
                        return REMOVED_FQNS.contains(fqTypeName);
                    }
                    return false;
                })) {
                    this.maybeRemoveImport(TypeAnnotationParameter.ORG_HIBERNATE_ANNOTATIONS_TYPE);
                    return null;
                }
                AtomicReference<String> temporalType = this.getTemporalTypeArgument(a);
                if (temporalType.get() != null) {
                    this.maybeAddImport("jakarta.persistence.Temporal");
                    this.maybeAddImport("jakarta.persistence.TemporalType");
                    this.maybeRemoveImport(TypeAnnotationParameter.ORG_HIBERNATE_ANNOTATIONS_TYPE);
                    return (J.Annotation)JavaTemplate.builder((String)("@Temporal(TemporalType." + temporalType.get().toUpperCase() + ")")).doBeforeParseTemplate(System.out::println).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.persistence-api"})).imports(new String[]{"jakarta.persistence.Temporal", "jakarta.persistence.TemporalType"}).build().apply(this.getCursor(), a.getCoordinates().replace(), new Object[0]);
                }
                return this.replaceArgumentWithClass(a);
            }

            private @Nullable Expression getAttributeValue(J.Annotation annotation, String attributeName) {
                List arguments = annotation.getArguments();
                if (arguments == null) {
                    return null;
                }
                for (Expression arg : arguments) {
                    J.Assignment assignment;
                    if (!(arg instanceof J.Assignment) || !((assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier) || !attributeName.equals(((J.Identifier)assignment.getVariable()).getSimpleName())) continue;
                    return assignment.getAssignment();
                }
                return null;
            }

            private AtomicReference<String> getTemporalTypeArgument(J.Annotation a) {
                AtomicReference<String> temporalType = new AtomicReference<String>();
                new JavaIsoVisitor<AtomicReference<String>>(){

                    public J.Assignment visitAssignment(J.Assignment assignment, AtomicReference<String> ref) {
                        J.Assignment as = super.visitAssignment(assignment, ref);
                        if (J.Literal.isLiteralValue((Expression)as.getAssignment(), (Object)"date") || J.Literal.isLiteralValue((Expression)as.getAssignment(), (Object)"time") || J.Literal.isLiteralValue((Expression)as.getAssignment(), (Object)"timestamp")) {
                            ref.set((String)((J.Literal)as.getAssignment()).getValue());
                        }
                        return as;
                    }
                }.visitNonNull((Tree)a, temporalType);
                return temporalType;
            }

            private J.Annotation replaceArgumentWithClass(J.Annotation a) {
                boolean isOnlyParameter = a.getArguments() != null && a.getArguments().size() == 1;
                return a.withArguments(ListUtils.map((List)a.getArguments(), arg -> {
                    J.Assignment assignment;
                    if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && "type".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && assignment.getAssignment() instanceof J.Literal) {
                        String fqTypeName = (String)((J.Literal)assignment.getAssignment()).getValue();
                        Expression nearestMessage = (Expression)this.getCursor().getNearestMessage(fqTypeName);
                        if (nearestMessage != null) {
                            if (isOnlyParameter) {
                                return (Expression)nearestMessage.withPrefix(Space.EMPTY);
                            }
                            return assignment.withVariable((Expression)((J.Identifier)assignment.getVariable()).withSimpleName("value")).withAssignment(nearestMessage);
                        }
                        J.Identifier identifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), TypeAnnotationParameter.getSimpleName(fqTypeName), JavaType.buildType((String)fqTypeName), null);
                        J.FieldAccess fa = new J.FieldAccess(Tree.randomId(), isOnlyParameter ? Space.EMPTY : assignment.getAssignment().getPrefix(), assignment.getAssignment().getMarkers(), (Expression)identifier, JLeftPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "class", null, null)), JavaType.buildType((String)"java.lang.Class"));
                        this.maybeAddImport(fqTypeName);
                        if (isOnlyParameter) {
                            return fa;
                        }
                        return assignment.withVariable((Expression)((J.Identifier)assignment.getVariable()).withSimpleName("value")).withAssignment((Expression)fa);
                    }
                    return arg;
                }));
            }
        };
        return Preconditions.check((TreeVisitor)new UsesType(ORG_HIBERNATE_ANNOTATIONS_TYPE, Boolean.valueOf(false)), (TreeVisitor)visitor);
    }

    private static String getSimpleName(String fqName) {
        int idx = fqName.lastIndexOf(46);
        if (idx > 0 && idx < fqName.length() - 1) {
            return fqName.substring(idx + 1);
        }
        return fqName;
    }
}

