/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class MigrateResultCheckStyleToExpectation
extends Recipe {
    private static final Map<String, String> MAPPING = new HashMap<String, String>();
    private static final Set<AnnotationMatcher> ANNOTATION_MATCHERS;

    public String getDisplayName() {
        return "Migration of `ResultCheckStyle` to `Expectation`";
    }

    public String getDescription() {
        return "Will migrate the usage of `org.hibernate.annotations.ResultCheckStyle` to `org.hibernate.jdbc.Expectation` in `@SQLInsert`, `@SqlUpdate`, `@SqlDelete` and `@SqlDeleteAll` annotations.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.hibernate.annotations.ResultCheckStyle", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation an = super.visitAnnotation(annotation, (Object)ctx);
                for (AnnotationMatcher m : ANNOTATION_MATCHERS) {
                    if (!m.matches(an)) continue;
                    return this.processAnnotation(an, ctx);
                }
                return an;
            }

            private J.Annotation processAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                List arguments = annotation.getArguments();
                if (arguments == null) {
                    return annotation;
                }
                for (Expression argument : arguments) {
                    J.Assignment assignment;
                    if (!(argument instanceof J.Assignment) || !this.isAssignmentToCheckParameter(assignment = (J.Assignment)argument)) continue;
                    return this.updateAnnotation(annotation, assignment, ctx);
                }
                return annotation;
            }

            private boolean isAssignmentToCheckParameter(J.Assignment assignment) {
                return assignment.getVariable() instanceof J.Identifier && "check".equals(((J.Identifier)assignment.getVariable()).getSimpleName());
            }

            private J.Annotation updateAnnotation(J.Annotation annotation, J.Assignment assignment, ExecutionContext ctx) {
                String map = this.getMappingForResultCheck(assignment);
                if (map != null) {
                    return this.applyTemplate(assignment, map, ctx);
                }
                return annotation;
            }

            private J.Annotation applyTemplate(J.Assignment assignment, String map, ExecutionContext ctx) {
                J.Annotation updatedAnnotation = (J.Annotation)JavaTemplate.builder((String)"verify = #{}").javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package org.hibernate.jdbc;public class Expectation { public static class None {} }"})).build().apply(this.getCursor(), assignment.getCoordinates().replace(), new Object[]{map});
                this.maybeAddImport("org.hibernate.jdbc.Expectation");
                this.maybeRemoveImport("org.hibernate.annotations.ResultCheckStyle");
                this.doAfterVisit((TreeVisitor)new ShortenFullyQualifiedTypeReferences().getVisitor());
                return updatedAnnotation;
            }

            private @Nullable String getMappingForResultCheck(J.Assignment assignment) {
                Expression value = assignment.getAssignment();
                if (value instanceof J.FieldAccess) {
                    return (String)MAPPING.get(((J.FieldAccess)value).getSimpleName());
                }
                if (value instanceof J.Identifier) {
                    return (String)MAPPING.get(((J.Identifier)value).getSimpleName());
                }
                return null;
            }
        });
    }

    static {
        MAPPING.put("NONE", "org.hibernate.jdbc.Expectation.None.class");
        MAPPING.put("COUNT", "org.hibernate.jdbc.Expectation.RowCount.class");
        MAPPING.put("PARAM", "org.hibernate.jdbc.Expectation.OutParameter.class");
        ANNOTATION_MATCHERS = Stream.of("SQLInsert", "SQLUpdate", "SQLDelete", "SQLDeleteAll").map(annotationName -> new AnnotationMatcher("@org.hibernate.annotations." + annotationName, Boolean.valueOf(true))).collect(Collectors.toSet());
    }
}

