/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson.codehaus;

import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;

public class RemoveDoublyAnnotatedCodehausAnnotations
extends Recipe {
    private static final AnnotationMatcher MATCHER_CODEHAUS = new AnnotationMatcher("@org.codehaus.jackson.map.annotate.JsonSerialize", Boolean.valueOf(true));
    private static final AnnotationMatcher MATCHER_FASTERXML = new AnnotationMatcher("@com.fasterxml.jackson.databind.annotation.JsonSerialize", Boolean.valueOf(true));

    public String getDisplayName() {
        return "Remove Codehaus Jackson annotations if doubly annotated";
    }

    public String getDescription() {
        return "Remove Codehaus Jackson annotations if they are doubly annotated with Jackson annotations from the `com.fasterxml.jackson` package.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("com.fasterxml.jackson.databind.annotation.JsonSerialize", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J preVisit(@NonNull J tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                final Map doubleAnnotated = (Map)new FindDoublyAnnotatedVisitor().reduce((Tree)tree, new HashMap());
                AnnotationMatcher removeCodehausMatcher = new AnnotationMatcher("@org.codehaus.jackson.map.annotate.JsonSerialize", true){

                    public boolean matches(J.Annotation annotation) {
                        return doubleAnnotated.containsKey(annotation);
                    }
                };
                this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(removeCodehausMatcher));
                this.maybeRemoveImport("org.codehaus.jackson.map.annotate.JsonSerialize.Inclusion.*");
                this.maybeRemoveImport("org.codehaus.jackson.map.annotate.JsonSerialize.Typing.*");
                this.doAfterVisit((TreeVisitor)new ShortenFullyQualifiedTypeReferences().getVisitor());
                return tree;
            }
        });
    }

    static class FindDoublyAnnotatedVisitor
    extends JavaIsoVisitor<Map<J.Annotation, J.Annotation>> {
        FindDoublyAnnotatedVisitor() {
        }

        public J.Annotation visitAnnotation(J.Annotation annotation, Map<J.Annotation, J.Annotation> doublyAnnotated) {
            J.Annotation a = super.visitAnnotation(annotation, doublyAnnotated);
            if (MATCHER_CODEHAUS.matches(annotation)) {
                ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor().getParentOrThrow()).stream().filter(arg_0 -> ((AnnotationMatcher)MATCHER_FASTERXML).matches(arg_0)).findFirst().ifPresent(fasterxml -> doublyAnnotated.put(annotation, (J.Annotation)fasterxml));
            }
            return a;
        }
    }
}

