/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson.codehaus;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.jackson.codehaus.RemoveDoublyAnnotatedCodehausAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class TransferJsonSerializeArgumentsFromCodehausToFasterXML
extends Recipe {
    private static final String[] TRANSFERABLE_ARGUMENTS = new String[]{"using", "contentUsing", "keyUsing", "nullUsing"};

    public String getDisplayName() {
        return "Transfer @JsonSerialize arguments from Codehaus to FasterXML";
    }

    public String getDescription() {
        return "Transfer @JsonSerialize annotation arguments (using, contentUsing, keyUsing, nullUsing) from Codehaus to FasterXML. If the argument was set already, it will not be transferred.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.codehaus.jackson.map.annotate.JsonSerialize", Boolean.valueOf(false)), new UsesType("com.fasterxml.jackson.databind.annotation.JsonSerialize", Boolean.valueOf(false))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J preVisit(@NonNull J tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                Map doubleAnnotated = (Map)new RemoveDoublyAnnotatedCodehausAnnotations.FindDoublyAnnotatedVisitor().reduce((Tree)tree, new HashMap());
                for (String argumentName : TRANSFERABLE_ARGUMENTS) {
                    this.transferArgument(doubleAnnotated, argumentName);
                }
                return tree;
            }

            private void transferArgument(Map<J.Annotation, J.Annotation> doubleAnnotated, String argumentName) {
                Map argumentExpressionMap = TransferJsonSerializeArgumentsFromCodehausToFasterXML.mapToArgumentExpression(doubleAnnotated, argumentName);
                this.doAfterVisit((TreeVisitor)new TransferArgumentsVisitor(argumentExpressionMap, argumentName));
            }
        });
    }

    private static Map<J.Annotation, Expression> mapToArgumentExpression(Map<J.Annotation, J.Annotation> doubleAnnotated, String argumentName) {
        HashMap<J.Annotation, Expression> mapToArgument = new HashMap<J.Annotation, Expression>();
        doubleAnnotated.forEach((key, value) -> {
            if (key.getArguments() != null || key.getArguments().isEmpty()) {
                key.getArguments().forEach(arg -> {
                    J.Assignment assign;
                    J.Identifier varId;
                    if (arg instanceof J.Assignment && argumentName.equals((varId = (J.Identifier)(assign = (J.Assignment)arg).getVariable()).getSimpleName())) {
                        mapToArgument.put((J.Annotation)value, (Expression)arg);
                    }
                });
            }
        });
        return mapToArgument;
    }

    private static class TransferArgumentsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Map<J.Annotation, Expression> fasterXmlToUsingExpression;
        private final String argumentName;

        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            Expression e = this.fasterXmlToUsingExpression.get(annotation);
            if (e != null) {
                List arguments = annotation.getArguments();
                if (arguments == null || arguments.isEmpty() || arguments.get(0) instanceof J.Empty) {
                    return annotation.withArguments(Collections.singletonList((Expression)e.withPrefix(Space.EMPTY)));
                }
                boolean notAlreadyUsing = arguments.stream().noneMatch(arg -> {
                    if (arg instanceof J.Assignment) {
                        J.Assignment assign = (J.Assignment)arg;
                        J.Identifier varId = (J.Identifier)assign.getVariable();
                        return this.argumentName.equals(varId.getSimpleName());
                    }
                    return false;
                });
                if (notAlreadyUsing) {
                    arguments.add(e);
                    return annotation.withArguments(arguments);
                }
            }
            return annotation;
        }

        @Generated
        public TransferArgumentsVisitor(Map<J.Annotation, Expression> fasterXmlToUsingExpression, String argumentName) {
            this.fasterXmlToUsingExpression = fasterXmlToUsingExpression;
            this.argumentName = argumentName;
        }
    }
}

