/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class RemoveRedundantJsonPropertyValue
extends Recipe {
    private static final String JACKSON_JSON_PROPERTY = "com.fasterxml.jackson.annotation.JsonProperty";
    private static final AnnotationMatcher JSON_PROPERTY_MATCHER = new AnnotationMatcher("@com.fasterxml.jackson.annotation.JsonProperty", Boolean.valueOf(true));

    public String getDisplayName() {
        return "Remove redundant `@JsonProperty` argument";
    }

    public String getDescription() {
        return "Remove `@JsonProperty` annotation or value attribute when the value matches the argument name.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(JACKSON_JSON_PROPERTY, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J parent;
                final J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
                if (JSON_PROPERTY_MATCHER.matches(a) && (parent = (J)this.getCursor().getParentTreeCursor().getValue()) instanceof J.VariableDeclarations) {
                    String parameterName = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)parent).getVariables().get(0)).getSimpleName();
                    J.Annotation modifiedAnnotation = this.processAnnotation(a, parameterName);
                    if (modifiedAnnotation != null) {
                        return modifiedAnnotation;
                    }
                    this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(new AnnotationMatcher("@com.fasterxml.jackson.annotation.JsonProperty"){

                        public boolean matches(J.Annotation annotation) {
                            return annotation == a;
                        }
                    }));
                    this.maybeRemoveImport(RemoveRedundantJsonPropertyValue.JACKSON_JSON_PROPERTY);
                    return a;
                }
                return a;
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.Annotation processAnnotation(J.Annotation annotation, String parameterName) {
                List args = annotation.getArguments();
                if (args == null || args.isEmpty() || args.get(0) instanceof J.Empty) {
                    return annotation;
                }
                List filteredArgs = ListUtils.map((List)args, arg -> {
                    J.Assignment assignment;
                    if (J.Literal.isLiteralValue((Expression)arg, (Object)parameterName)) {
                        return null;
                    }
                    if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && "value".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && J.Literal.isLiteralValue((Expression)assignment.getAssignment(), (Object)parameterName)) {
                        return null;
                    }
                    return arg;
                });
                if (filteredArgs.isEmpty()) {
                    return null;
                }
                return annotation.withArguments(ListUtils.mapFirst((List)filteredArgs, firstArg -> (Expression)Objects.requireNonNull(firstArg).withPrefix(((Expression)annotation.getArguments().get(0)).getPrefix())));
            }
        });
    }
}

