/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveBuiltInModuleRegistrations
extends Recipe {
    private static final String OBJECT_MAPPER_TYPE = "com.fasterxml.jackson.databind.ObjectMapper";
    private static final MethodMatcher REGISTER_MODULE = new MethodMatcher("com.fasterxml.jackson.databind.ObjectMapper registerModule*(..)");
    private static final Set<String> BUILT_IN_MODULES = new HashSet<String>(Arrays.asList("com.fasterxml.jackson.module.paramnames.ParameterNamesModule", "com.fasterxml.jackson.datatype.jdk8.Jdk8Module", "com.fasterxml.jackson.datatype.jsr310.JavaTimeModule"));

    public String getDisplayName() {
        return "Remove registrations of modules built-in to Jackson 3";
    }

    public String getDescription() {
        return "In Jackson 3, `ParameterNamesModule`, `Jdk8Module`, and `JavaTimeModule` are built into `jackson-databind` and no longer need to be registered manually. This recipe removes `ObjectMapper.registerModule()` calls for these modules.";
    }

    public Set<String> getTags() {
        return Collections.singleton("jackson-3");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(REGISTER_MODULE), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public @Nullable J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (REGISTER_MODULE.matches((MethodCall)method) && method.getArguments().stream().anyMatch(this::isBuiltInModuleInstantiation)) {
                    for (String module : BUILT_IN_MODULES) {
                        this.maybeRemoveImport(module);
                    }
                    if (method.getSelect() instanceof J.MethodInvocation || method.getSelect() instanceof J.NewClass) {
                        return method.getSelect().withPrefix(method.getPrefix());
                    }
                    return null;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            public @Nullable J visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)ctx);
                JavaType type = mv.getType();
                if (type != null && BUILT_IN_MODULES.contains(TypeUtils.toString((JavaType)type))) {
                    return null;
                }
                return mv;
            }

            private boolean isBuiltInModuleInstantiation(Expression expr) {
                J.NewClass newClass;
                if (expr instanceof J.NewClass && (newClass = (J.NewClass)expr).getClazz() != null) {
                    JavaType type = newClass.getClazz().getType();
                    return type != null && BUILT_IN_MODULES.contains(TypeUtils.toString((JavaType)type));
                }
                JavaType type = expr.getType();
                return type != null && BUILT_IN_MODULES.contains(TypeUtils.toString((JavaType)type));
            }
        });
    }
}

