/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp.dependencies.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class VulnerabilityReport
extends DataTable<Row> {
    public VulnerabilityReport(Recipe recipe) {
        super(recipe, "Vulnerability report", "A vulnerability report that includes detailed information about the affected artifact and the corresponding CVEs.");
    }

    public static final class Row {
        @Column(displayName="CVE", description="The CVE number.")
        private final String cve;
        @Column(displayName="Package name", description="The package name.")
        private final String packageName;
        @Column(displayName="Version", description="The resolved version.")
        private final String version;
        @Column(displayName="Fixed in version", description="The minimum version that is no longer vulnerable.")
        private final String fixedVersion;
        @Column(displayName="Fixable with version update only", description="Whether the vulnerability is likely to be fixed by increasing the dependency version only, with no code modifications required. This is a heuristic which assumes that the dependency is accurately versioned according to [semver](https://semver.org/).")
        private final boolean fixWithVersionUpdateOnly;
        @Column(displayName="Summary", description="The summary of the CVE.")
        private final String summary;
        @Column(displayName="Base score", description="The calculated base score.")
        private final String severity;
        @Column(displayName="Depth", description="Zero for direct dependencies.")
        private final Integer depth;
        @Column(displayName="CWEs", description="Common Weakness Enumeration (CWE) identifiers; semicolon separated.")
        private final String CWEs;

        @ConstructorProperties(value={"cve", "packageName", "version", "fixedVersion", "fixWithVersionUpdateOnly", "summary", "severity", "depth", "CWEs"})
        @Generated
        public Row(String cve, String packageName, String version, String fixedVersion, boolean fixWithVersionUpdateOnly, String summary, String severity, Integer depth, String CWEs) {
            this.cve = cve;
            this.packageName = packageName;
            this.version = version;
            this.fixedVersion = fixedVersion;
            this.fixWithVersionUpdateOnly = fixWithVersionUpdateOnly;
            this.summary = summary;
            this.severity = severity;
            this.depth = depth;
            this.CWEs = CWEs;
        }

        @Generated
        public String getCve() {
            return this.cve;
        }

        @Generated
        public String getPackageName() {
            return this.packageName;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getFixedVersion() {
            return this.fixedVersion;
        }

        @Generated
        public boolean isFixWithVersionUpdateOnly() {
            return this.fixWithVersionUpdateOnly;
        }

        @Generated
        public String getSummary() {
            return this.summary;
        }

        @Generated
        public String getSeverity() {
            return this.severity;
        }

        @Generated
        public Integer getDepth() {
            return this.depth;
        }

        @Generated
        public String getCWEs() {
            return this.CWEs;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.isFixWithVersionUpdateOnly() != other.isFixWithVersionUpdateOnly()) {
                return false;
            }
            Integer this$depth = this.getDepth();
            Integer other$depth = other.getDepth();
            if (this$depth == null ? other$depth != null : !((Object)this$depth).equals(other$depth)) {
                return false;
            }
            String this$cve = this.getCve();
            String other$cve = other.getCve();
            if (this$cve == null ? other$cve != null : !this$cve.equals(other$cve)) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$fixedVersion = this.getFixedVersion();
            String other$fixedVersion = other.getFixedVersion();
            if (this$fixedVersion == null ? other$fixedVersion != null : !this$fixedVersion.equals(other$fixedVersion)) {
                return false;
            }
            String this$summary = this.getSummary();
            String other$summary = other.getSummary();
            if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
                return false;
            }
            String this$severity = this.getSeverity();
            String other$severity = other.getSeverity();
            if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
                return false;
            }
            String this$CWEs = this.getCWEs();
            String other$CWEs = other.getCWEs();
            return !(this$CWEs == null ? other$CWEs != null : !this$CWEs.equals(other$CWEs));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFixWithVersionUpdateOnly() ? 79 : 97);
            Integer $depth = this.getDepth();
            result = result * 59 + ($depth == null ? 43 : ((Object)$depth).hashCode());
            String $cve = this.getCve();
            result = result * 59 + ($cve == null ? 43 : $cve.hashCode());
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $fixedVersion = this.getFixedVersion();
            result = result * 59 + ($fixedVersion == null ? 43 : $fixedVersion.hashCode());
            String $summary = this.getSummary();
            result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
            String $severity = this.getSeverity();
            result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
            String $CWEs = this.getCWEs();
            result = result * 59 + ($CWEs == null ? 43 : $CWEs.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "VulnerabilityReport.Row(cve=" + this.getCve() + ", packageName=" + this.getPackageName() + ", version=" + this.getVersion() + ", fixedVersion=" + this.getFixedVersion() + ", fixWithVersionUpdateOnly=" + this.isFixWithVersionUpdateOnly() + ", summary=" + this.getSummary() + ", severity=" + this.getSeverity() + ", depth=" + this.getDepth() + ", CWEs=" + this.getCWEs() + ")";
        }
    }
}

