/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Markup;

public final class UpgradeJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="17")
    private final Integer version;
    @Option(displayName="Distribution", description="The distribution of Java to use. When omitted the current distribution is maintained.", example="openjdk")
    @Nullable
    private final String distribution;

    public String getDisplayName() {
        return "Upgrade Jenkins Java version";
    }

    public String getDescription() {
        return "Upgrades the version of java specified in Jenkins groovy scripts. Will not downgrade if the version is newer than the specified version.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles("**/Jenkinsfile"), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
                String targetJdkString;
                int jdkVersion;
                J.Assignment a = super.visitAssignment(assignment, (Object)ctx);
                if (!(a.getVariable() instanceof J.Identifier) || !(a.getAssignment() instanceof J.Literal)) {
                    return a;
                }
                J.Identifier id = (J.Identifier)a.getVariable();
                J.Literal value = (J.Literal)a.getAssignment();
                if (!"java_version".equals(id.getSimpleName()) && !"javaVersion".equals(id.getSimpleName()) || !(value.getValue() instanceof String)) {
                    return a;
                }
                String currentJdkString = ((String)value.getValue()).trim();
                int versionBeginsIndex = StringUtils.indexOf((String)currentJdkString, Character::isDigit);
                String currentJdkDistribution = currentJdkString.substring(0, versionBeginsIndex);
                String currentJdkVersion = currentJdkString.substring(versionBeginsIndex);
                try {
                    jdkVersion = Integer.parseInt(currentJdkVersion);
                }
                catch (NumberFormatException e) {
                    return (J.Assignment)Markup.warn((Tree)a, (Throwable)new IllegalStateException("Unable to parse JDK version", e));
                }
                String targetVersion = currentJdkVersion;
                if (jdkVersion < UpgradeJavaVersion.this.version) {
                    targetVersion = String.valueOf(UpgradeJavaVersion.this.version);
                }
                String targetDistribution = currentJdkDistribution;
                if (UpgradeJavaVersion.this.distribution != null) {
                    targetDistribution = UpgradeJavaVersion.this.distribution;
                }
                if (!(targetJdkString = targetDistribution + targetVersion).equals(currentJdkString)) {
                    char quote = value.getValueSource() == null ? (char)'\'' : (char)value.getValueSource().charAt(0);
                    a = a.withAssignment((Expression)value.withValue((Object)targetJdkString).withValueSource(quote + targetJdkString + quote));
                }
                return a;
            }
        });
    }

    @ConstructorProperties(value={"version", "distribution"})
    @Generated
    public UpgradeJavaVersion(Integer version, @Nullable String distribution) {
        this.version = version;
        this.distribution = distribution;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Nullable
    @Generated
    public String getDistribution() {
        return this.distribution;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeJavaVersion(version=" + this.getVersion() + ", distribution=" + this.getDistribution() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeJavaVersion)) {
            return false;
        }
        UpgradeJavaVersion other = (UpgradeJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        return !(this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeJavaVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        return result;
    }
}

