/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kubernetes;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.kubernetes.ContainerImage;
import org.openrewrite.kubernetes.tree.K8S;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UpdateContainerImageName
extends Recipe {
    @Option(displayName="Repository to find", description="The repository part of the image name to search for in containers and initContainers.", example="gcr.io", required=false)
    private final @Nullable String repoToFind;
    @Option(displayName="Image name to find", description="The image name to search for in containers and initContainers.", example="nginx")
    private final String imageToFind;
    @Option(displayName="Image tag to find", description="The tag part of the image name to search for in containers and initContainers.", example="v1.2.3", required=false)
    private final @Nullable String tagToFind;
    @Option(displayName="Image digest to find", description="The digest part of the image name to search for in containers and initContainers.", example="sha256:cb5c1bddd1b5665e1867a7fa1b5fa843a47ee433bbb75d4293888b71def53229", required=false)
    private final @Nullable String digestToFind;
    @Option(displayName="Repository to update", description="The repository part of the image name to update to in containers and initContainers.", example="gcr.io/account/bucket", required=false)
    private final @Nullable String repoToUpdate;
    @Option(displayName="Image name to update", description="The image name to update to in containers and initContainers.", example="nginx", required=false)
    private final @Nullable String imageToUpdate;
    @Option(displayName="Image tag to update", description="The tag part of the image name to update to in containers and initContainers.", example="v1.2.3", required=false)
    private final @Nullable String tagToUpdate;
    @Option(displayName="Image digest to update", description="The digest part of the image name to update to in containers and initContainers.", example="sha256:cb5c1bddd1b5665e1867a7fa1b5fa843a47ee433bbb75d4293888b71def53229", required=false)
    private final @Nullable String digestToUpdate;
    @Option(displayName="Include initContainers", description="Boolean to indicate whether or not to treat initContainers/image identically to containers/image.", example="false", required=false)
    private final boolean includeInitContainers;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/pod-*.yml")
    private final @Nullable String fileMatcher;

    public String getDisplayName() {
        return "Update image name";
    }

    public String getDescription() {
        return "Search for image names that match patterns and replace the components of the name with new values.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final ContainerImage.ImageName imageToSearch = new ContainerImage.ImageName(this.repoToFind, this.imageToFind, this.tagToFind, this.digestToFind);
        YamlIsoVisitor<ExecutionContext> visitor = new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                ContainerImage image;
                Cursor c = this.getCursor();
                if ((K8S.Containers.inContainerSpec(c) || UpdateContainerImageName.this.includeInitContainers && K8S.InitContainers.inInitContainerSpec(c)) && K8S.Containers.isImageName(c) && (image = new ContainerImage(scalar.getValue())).getImageName().matches(imageToSearch)) {
                    ContainerImage.ImageName newName = image.getImageName();
                    if (null != UpdateContainerImageName.this.repoToUpdate) {
                        newName = newName.withRepository(UpdateContainerImageName.this.repoToUpdate);
                    }
                    if (null != UpdateContainerImageName.this.imageToUpdate) {
                        newName = newName.withImage(UpdateContainerImageName.this.imageToUpdate);
                    }
                    if (null != UpdateContainerImageName.this.tagToUpdate) {
                        newName = newName.withTag(UpdateContainerImageName.this.tagToUpdate);
                    }
                    if (null != UpdateContainerImageName.this.digestToUpdate) {
                        newName = newName.withDigest(UpdateContainerImageName.this.digestToUpdate);
                    }
                    return scalar.withValue(newName.toString());
                }
                return super.visitScalar(scalar, (Object)ctx);
            }
        };
        return this.fileMatcher != null ? Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher), (TreeVisitor)visitor) : visitor;
    }

    @ConstructorProperties(value={"repoToFind", "imageToFind", "tagToFind", "digestToFind", "repoToUpdate", "imageToUpdate", "tagToUpdate", "digestToUpdate", "includeInitContainers", "fileMatcher"})
    @Generated
    public UpdateContainerImageName(@Nullable String repoToFind, String imageToFind, @Nullable String tagToFind, @Nullable String digestToFind, @Nullable String repoToUpdate, @Nullable String imageToUpdate, @Nullable String tagToUpdate, @Nullable String digestToUpdate, boolean includeInitContainers, @Nullable String fileMatcher) {
        this.repoToFind = repoToFind;
        this.imageToFind = imageToFind;
        this.tagToFind = tagToFind;
        this.digestToFind = digestToFind;
        this.repoToUpdate = repoToUpdate;
        this.imageToUpdate = imageToUpdate;
        this.tagToUpdate = tagToUpdate;
        this.digestToUpdate = digestToUpdate;
        this.includeInitContainers = includeInitContainers;
        this.fileMatcher = fileMatcher;
    }

    @Generated
    public @Nullable String getRepoToFind() {
        return this.repoToFind;
    }

    @Generated
    public String getImageToFind() {
        return this.imageToFind;
    }

    @Generated
    public @Nullable String getTagToFind() {
        return this.tagToFind;
    }

    @Generated
    public @Nullable String getDigestToFind() {
        return this.digestToFind;
    }

    @Generated
    public @Nullable String getRepoToUpdate() {
        return this.repoToUpdate;
    }

    @Generated
    public @Nullable String getImageToUpdate() {
        return this.imageToUpdate;
    }

    @Generated
    public @Nullable String getTagToUpdate() {
        return this.tagToUpdate;
    }

    @Generated
    public @Nullable String getDigestToUpdate() {
        return this.digestToUpdate;
    }

    @Generated
    public boolean isIncludeInitContainers() {
        return this.includeInitContainers;
    }

    @Generated
    public @Nullable String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateContainerImageName(repoToFind=" + this.getRepoToFind() + ", imageToFind=" + this.getImageToFind() + ", tagToFind=" + this.getTagToFind() + ", digestToFind=" + this.getDigestToFind() + ", repoToUpdate=" + this.getRepoToUpdate() + ", imageToUpdate=" + this.getImageToUpdate() + ", tagToUpdate=" + this.getTagToUpdate() + ", digestToUpdate=" + this.getDigestToUpdate() + ", includeInitContainers=" + this.isIncludeInitContainers() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateContainerImageName)) {
            return false;
        }
        UpdateContainerImageName other = (UpdateContainerImageName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isIncludeInitContainers() != other.isIncludeInitContainers()) {
            return false;
        }
        String this$repoToFind = this.getRepoToFind();
        String other$repoToFind = other.getRepoToFind();
        if (this$repoToFind == null ? other$repoToFind != null : !this$repoToFind.equals(other$repoToFind)) {
            return false;
        }
        String this$imageToFind = this.getImageToFind();
        String other$imageToFind = other.getImageToFind();
        if (this$imageToFind == null ? other$imageToFind != null : !this$imageToFind.equals(other$imageToFind)) {
            return false;
        }
        String this$tagToFind = this.getTagToFind();
        String other$tagToFind = other.getTagToFind();
        if (this$tagToFind == null ? other$tagToFind != null : !this$tagToFind.equals(other$tagToFind)) {
            return false;
        }
        String this$digestToFind = this.getDigestToFind();
        String other$digestToFind = other.getDigestToFind();
        if (this$digestToFind == null ? other$digestToFind != null : !this$digestToFind.equals(other$digestToFind)) {
            return false;
        }
        String this$repoToUpdate = this.getRepoToUpdate();
        String other$repoToUpdate = other.getRepoToUpdate();
        if (this$repoToUpdate == null ? other$repoToUpdate != null : !this$repoToUpdate.equals(other$repoToUpdate)) {
            return false;
        }
        String this$imageToUpdate = this.getImageToUpdate();
        String other$imageToUpdate = other.getImageToUpdate();
        if (this$imageToUpdate == null ? other$imageToUpdate != null : !this$imageToUpdate.equals(other$imageToUpdate)) {
            return false;
        }
        String this$tagToUpdate = this.getTagToUpdate();
        String other$tagToUpdate = other.getTagToUpdate();
        if (this$tagToUpdate == null ? other$tagToUpdate != null : !this$tagToUpdate.equals(other$tagToUpdate)) {
            return false;
        }
        String this$digestToUpdate = this.getDigestToUpdate();
        String other$digestToUpdate = other.getDigestToUpdate();
        if (this$digestToUpdate == null ? other$digestToUpdate != null : !this$digestToUpdate.equals(other$digestToUpdate)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpdateContainerImageName;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeInitContainers() ? 79 : 97);
        String $repoToFind = this.getRepoToFind();
        result = result * 59 + ($repoToFind == null ? 43 : $repoToFind.hashCode());
        String $imageToFind = this.getImageToFind();
        result = result * 59 + ($imageToFind == null ? 43 : $imageToFind.hashCode());
        String $tagToFind = this.getTagToFind();
        result = result * 59 + ($tagToFind == null ? 43 : $tagToFind.hashCode());
        String $digestToFind = this.getDigestToFind();
        result = result * 59 + ($digestToFind == null ? 43 : $digestToFind.hashCode());
        String $repoToUpdate = this.getRepoToUpdate();
        result = result * 59 + ($repoToUpdate == null ? 43 : $repoToUpdate.hashCode());
        String $imageToUpdate = this.getImageToUpdate();
        result = result * 59 + ($imageToUpdate == null ? 43 : $imageToUpdate.hashCode());
        String $tagToUpdate = this.getTagToUpdate();
        result = result * 59 + ($tagToUpdate == null ? 43 : $tagToUpdate.hashCode());
        String $digestToUpdate = this.getDigestToUpdate();
        result = result * 59 + ($digestToUpdate == null ? 43 : $digestToUpdate.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

