/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.liberty;

import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.staticanalysis.RemoveUnusedLocalVariables;
import org.openrewrite.staticanalysis.RemoveUnusedPrivateFields;

public class RemoveWas2LibertyNonPortableJndiLookup
extends ScanningRecipe<Set<JavaType.Variable>> {
    private final String INITIAL_PROPERTY = "java.naming.factory.initial";
    private final String URL_PROPERTY = "java.naming.provider.url";

    public String getDisplayName() {
        return "Removes invalid JNDI properties";
    }

    public String getDescription() {
        return "Remove the use of invalid JNDI properties from Hashtable.";
    }

    public Set<JavaType.Variable> getInitialValue(ExecutionContext ctx) {
        return new HashSet<JavaType.Variable>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Set<JavaType.Variable> acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
                for (J.VariableDeclarations.NamedVariable variable : vd.getVariables()) {
                    Expression initializer = variable.getInitializer();
                    if (initializer == null) continue;
                    this.checkForPropertiesVariable(variable.getVariableType(), initializer);
                }
                return vd;
            }

            public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
                Expression assignmentVariable = assignment.getVariable();
                if (!(assignmentVariable instanceof J.Identifier)) {
                    return assignment;
                }
                J.Identifier assignmentVariableIdentifier = (J.Identifier)assignmentVariable;
                JavaType.Variable variable = assignmentVariableIdentifier.getFieldType();
                if (!this.checkForPropertiesVariable(variable, assignment.getAssignment())) {
                    acc.remove(variable);
                }
                return assignment;
            }

            private boolean checkForPropertiesVariable(JavaType.Variable variable, Expression value) {
                String stringValue;
                if (value instanceof J.Literal && ((stringValue = ((J.Literal)value).toString()).equals("java.naming.factory.initial") || stringValue.equals("java.naming.provider.url"))) {
                    acc.add(variable);
                    return true;
                }
                return false;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Set<JavaType.Variable> acc) {
        final MethodMatcher methodMatcher = new MethodMatcher("java.util.Hashtable put(..)", false);
        return new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                if (!methodMatcher.matches((MethodCall)mi)) {
                    return mi;
                }
                Expression firstArgument = (Expression)mi.getArguments().get(0);
                if (firstArgument instanceof J.Literal) {
                    String stringValue = ((J.Literal)firstArgument).toString();
                    if (!stringValue.equals("java.naming.factory.initial") && !stringValue.equals("java.naming.provider.url")) {
                        return mi;
                    }
                } else if (firstArgument instanceof J.Identifier) {
                    if (!acc.contains(((J.Identifier)firstArgument).getFieldType())) {
                        return mi;
                    }
                    this.doAfterVisit(new RemoveUnusedLocalVariables(null, null).getVisitor());
                    this.doAfterVisit(new RemoveUnusedPrivateFields().getVisitor());
                }
                return null;
            }
        };
    }
}

