/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.liberty;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ServerName
extends Recipe {
    private static final String SERVER_NAME = "com.ibm.websphere.runtime.ServerName";
    private static final MethodMatcher GET_DISPLAY_NAME = new MethodMatcher("com.ibm.websphere.runtime.ServerName getDisplayName()");
    private static final MethodMatcher GET_FULL_NAME = new MethodMatcher("com.ibm.websphere.runtime.ServerName getFullName()");
    private static final String ADMIN_SERVICE = "com.ibm.websphere.management.AdminService";
    private static final MethodMatcher GET_PROCESS_NAME = new MethodMatcher("com.ibm.websphere.management.AdminService getProcessName()");
    private static final String RAS_HELPER = "com.ibm.ejs.ras.RasHelper";
    private static final MethodMatcher GET_SERVER_NAME = new MethodMatcher("com.ibm.ejs.ras.RasHelper getServerName()");

    public String getDisplayName() {
        return "Use `getProperty(\"wlp.server.name\")`";
    }

    public String getDescription() {
        return "`ServerName.getDisplayName()` is not available in Liberty.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                if (GET_DISPLAY_NAME.matches((MethodCall)elem) || GET_FULL_NAME.matches((MethodCall)elem) || GET_PROCESS_NAME.matches((MethodCall)elem) || GET_SERVER_NAME.matches((MethodCall)elem)) {
                    this.maybeRemoveImport(ServerName.SERVER_NAME);
                    this.maybeRemoveImport(ServerName.ADMIN_SERVICE);
                    this.maybeRemoveImport(ServerName.RAS_HELPER);
                    return (J.MethodInvocation)JavaTemplate.builder((String)"System.getProperty(\"wlp.server.name\")").build().apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]);
                }
                return super.visitMethodInvocation(elem, (Object)ctx);
            }
        };
    }
}

