/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.liberty;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ServerName
extends Recipe {
    private static final String SERVER_NAME = "com.ibm.websphere.runtime.ServerName";
    private static final MethodMatcher getDisplayName = new MethodMatcher("com.ibm.websphere.runtime.ServerName getDisplayName()");
    private static final MethodMatcher getFullName = new MethodMatcher("com.ibm.websphere.runtime.ServerName getFullName()");

    public String getDisplayName() {
        return "Use `getProperty(\"wlp.server.name\")`";
    }

    public String getDescription() {
        return "`ServerName.getDisplayName()` is not available in Liberty.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                if (getDisplayName.matches((MethodCall)elem) || getFullName.matches((MethodCall)elem)) {
                    this.maybeRemoveImport(ServerName.SERVER_NAME);
                    return JavaTemplate.builder((String)"System.getProperty(\"wlp.server.name\")").build().apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]);
                }
                return super.visitMethodInvocation(elem, (Object)ctx);
            }
        };
    }
}

