/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.liberty;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class WebSphereUnavailableSSOCookieMethod
extends Recipe {
    private static final String WSSECURITY_HELPER = "com.ibm.websphere.security.WSSecurityHelper";
    private static final MethodMatcher METHOD_PATTERN = new MethodMatcher("com.ibm.websphere.security.WSSecurityHelper revokeSSOCookies(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)");

    public String getDisplayName() {
        return "Replace `revokeSSOCookies` with `logout`";
    }

    public String getDescription() {
        return "Replace `WSSecurityHelper.revokeSSOCookies(request, response)` with `request.logout()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (METHOD_PATTERN.matches((MethodCall)method)) {
                    this.maybeRemoveImport(WebSphereUnavailableSSOCookieMethod.WSSECURITY_HELPER);
                    return JavaTemplate.builder((String)"#{any()}.logout()").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"websecurity_logout_test"})).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    @Generated
    public WebSphereUnavailableSSOCookieMethod() {
    }

    @Generated
    public String toString() {
        return "WebSphereUnavailableSSOCookieMethod()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSphereUnavailableSSOCookieMethod)) {
            return false;
        }
        WebSphereUnavailableSSOCookieMethod other = (WebSphereUnavailableSSOCookieMethod)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebSphereUnavailableSSOCookieMethod;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

