/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.AddLogger;
import org.openrewrite.java.logging.LoggingFramework;
import org.openrewrite.java.search.FindFieldsOfType;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public final class PrintStackTraceToLogError
extends Recipe {
    @Option(displayName="Add logger", description="Add a logger field to the class if it isn't already present.", required=false)
    @Nullable
    private final Boolean addLogger;
    @Option(displayName="Logger name", description="The name of the logger to use when generating a field.", required=false)
    @Nullable
    private final String loggerName;
    @Option(displayName="Logging framework", description="The logging framework to use.", valid={"SLF4J", "Log4J", "Log4J2", "JUL"}, required=false)
    @Nullable
    private final String loggingFramework;

    public String getDisplayName() {
        return "Use logger instead of `printStackTrace()`";
    }

    public String getDescription() {
        return "When a logger is present, log exceptions rather than calling `printStackTrace()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        if (this.addLogger != null && this.addLogger.booleanValue()) {
            return null;
        }
        final LoggingFramework framework = LoggingFramework.fromOption(this.loggingFramework);
        return new JavaVisitor<ExecutionContext>(){

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit((TreeVisitor)new UsesType(framework.getLoggerType()));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher printStackTrace = new MethodMatcher("java.lang.Throwable printStackTrace(..)");
        final LoggingFramework framework = LoggingFramework.fromOption(this.loggingFramework);
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (printStackTrace.matches(m)) {
                    J.ClassDeclaration clazz = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
                    Set loggers = FindFieldsOfType.find((J)clazz, (String)framework.getLoggerType());
                    if (!loggers.isEmpty()) {
                        m = (J.MethodInvocation)m.withTemplate((SourceTemplate)framework.getErrorTemplate(this, "\"Exception\""), m.getCoordinates().replace(), new Object[]{((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)loggers.iterator().next()).getVariables().get(0)).getName(), m.getSelect()});
                        if (framework == LoggingFramework.JUL) {
                            this.maybeAddImport("java.util.logging.Level");
                        }
                    } else if (PrintStackTraceToLogError.this.addLogger != null && PrintStackTraceToLogError.this.addLogger.booleanValue()) {
                        this.doAfterVisit(AddLogger.addLogger(clazz, framework, PrintStackTraceToLogError.this.loggerName == null ? "logger" : PrintStackTraceToLogError.this.loggerName));
                        this.doAfterVisit((TreeVisitor)this);
                    }
                }
                return m;
            }
        };
    }

    @ConstructorProperties(value={"addLogger", "loggerName", "loggingFramework"})
    public PrintStackTraceToLogError(@Nullable Boolean addLogger, @Nullable String loggerName, @Nullable String loggingFramework) {
        this.addLogger = addLogger;
        this.loggerName = loggerName;
        this.loggingFramework = loggingFramework;
    }

    @Nullable
    public Boolean getAddLogger() {
        return this.addLogger;
    }

    @Nullable
    public String getLoggerName() {
        return this.loggerName;
    }

    @Nullable
    public String getLoggingFramework() {
        return this.loggingFramework;
    }

    @NonNull
    public String toString() {
        return "PrintStackTraceToLogError(addLogger=" + this.getAddLogger() + ", loggerName=" + this.getLoggerName() + ", loggingFramework=" + this.getLoggingFramework() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrintStackTraceToLogError)) {
            return false;
        }
        PrintStackTraceToLogError other = (PrintStackTraceToLogError)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addLogger = this.getAddLogger();
        Boolean other$addLogger = other.getAddLogger();
        if (this$addLogger == null ? other$addLogger != null : !((Object)this$addLogger).equals(other$addLogger)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        String this$loggingFramework = this.getLoggingFramework();
        String other$loggingFramework = other.getLoggingFramework();
        return !(this$loggingFramework == null ? other$loggingFramework != null : !this$loggingFramework.equals(other$loggingFramework));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PrintStackTraceToLogError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addLogger = this.getAddLogger();
        result = result * 59 + ($addLogger == null ? 43 : ((Object)$addLogger).hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        String $loggingFramework = this.getLoggingFramework();
        result = result * 59 + ($loggingFramework == null ? 43 : $loggingFramework.hashCode());
        return result;
    }
}

