/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class LoggersNamedForEnclosingClass
extends Recipe {
    private static final MethodMatcher LOGGERFACTORY_GETLOGGER = new MethodMatcher("org.slf4j.LoggerFactory getLogger(Class)");

    public String getDisplayName() {
        return "Loggers should be named for their enclosing classes";
    }

    public String getDescription() {
        return "Ensure `LoggerFactory#getLogger(Class)` is called with the enclosing class as argument.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.slf4j.LoggerFactory");
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3416");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext p) {
                String argumentClazzName;
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)p);
                if (!LOGGERFACTORY_GETLOGGER.matches(mi)) {
                    return mi;
                }
                J.ClassDeclaration firstEnclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (firstEnclosingClass == null) {
                    return mi;
                }
                String enclosingClazzName = firstEnclosingClass.getSimpleName() + ".class";
                if (mi.getArguments().get(0) instanceof J.FieldAccess && enclosingClazzName.equals(argumentClazzName = ((J.FieldAccess)mi.getArguments().get(0)).toString())) {
                    return mi;
                }
                return (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"LoggerFactory.getLogger(#{})").javaParser(() -> JavaParser.fromJavaVersion().classpath(new String[]{"slf4j-api"}).build()).build(), mi.getCoordinates().replace(), new Object[]{enclosingClazzName});
            }
        };
    }
}

