/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public final class ParameterizedLogging
extends Recipe {
    @Option(displayName="Method pattern", description="A method used to find matching statements to parameterize.", example="org.slf4j.Logger info(..)")
    private final String methodPattern;
    @Option(displayName="Remove `Object#toString()` invocations from logging parameters", description="Optionally remove `toString(`) method invocations from Object parameters.", required=false)
    @Nullable
    private final Boolean removeToString;

    public String getDisplayName() {
        return "Parameterize logging statements";
    }

    public String getDescription() {
        return "Transform logging statements using concatenation for messages and variables into a parameterized format. For example, `logger.info(\"hi \" + userName)` becomes `logger.info(\"hi {}\", userName)`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-2629", "RSPEC-3457"));
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(this.methodPattern, true);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher matcher;
            private final RemoveToStringVisitor removeToStringVisitor;
            {
                this.matcher = new MethodMatcher(ParameterizedLogging.this.methodPattern, true);
                this.removeToStringVisitor = new RemoveToStringVisitor();
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (this.matcher.matches(m) && !m.getArguments().isEmpty() && !(m.getArguments().get(0) instanceof J.Empty) && m.getArguments().size() <= 2) {
                    Expression logMsg = (Expression)m.getArguments().get(0);
                    if (logMsg instanceof J.Binary) {
                        StringBuilder messageBuilder = new StringBuilder("\"");
                        ArrayList newArgList = new ArrayList();
                        ListUtils.map((List)m.getArguments(), (index, message) -> {
                            if (index == 0 && message instanceof J.Binary) {
                                MessageAndArguments literalAndArgs = ParameterizedLogging.concatenationToLiteral(message, new MessageAndArguments("", new ArrayList()));
                                messageBuilder.append(literalAndArgs.message);
                                newArgList.addAll(literalAndArgs.arguments);
                            } else {
                                newArgList.add(message);
                            }
                            return message;
                        });
                        messageBuilder.append("\"");
                        newArgList.forEach(arg -> messageBuilder.append(", #{any()}"));
                        m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)messageBuilder.toString()).build(), m.getCoordinates().replaceArguments(), newArgList.toArray());
                    } else if (!TypeUtils.isString((JavaType)logMsg.getType()) && logMsg.getType() instanceof JavaType.Class) {
                        StringBuilder messageBuilder = new StringBuilder("\"{}\"");
                        m.getArguments().forEach(arg -> messageBuilder.append(", #{any()}"));
                        m = (J.MethodInvocation)m.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)messageBuilder.toString()).build(), m.getCoordinates().replaceArguments(), m.getArguments().toArray());
                    }
                    if (Boolean.TRUE.equals(ParameterizedLogging.this.removeToString)) {
                        m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> (Expression)this.removeToStringVisitor.visitNonNull((Tree)arg, ctx, this.getCursor())));
                    }
                }
                return m;
            }

            class RemoveToStringVisitor
            extends JavaVisitor<ExecutionContext> {
                private final JavaTemplate t = JavaTemplate.builder(() -> ((RemoveToStringVisitor)this).getCursor(), (String)"#{any(java.lang.String)}").build();
                private final MethodMatcher TO_STRING = new MethodMatcher("java.lang.Object toString()");

                RemoveToStringVisitor() {
                }

                public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                    if (((Boolean)this.getCursor().getNearestMessage("DO_NOT_REMOVE", (Object)Boolean.FALSE)).booleanValue()) {
                        return method;
                    }
                    if (this.TO_STRING.matches(method.getSelect())) {
                        this.getCursor().putMessage("DO_NOT_REMOVE", (Object)Boolean.TRUE);
                    } else if (this.TO_STRING.matches(method)) {
                        return method.withTemplate((SourceTemplate)this.t, method.getCoordinates().replace(), new Object[]{method.getSelect()});
                    }
                    return super.visitMethodInvocation(method, (Object)ctx);
                }
            }
        };
    }

    private static MessageAndArguments concatenationToLiteral(Expression message, MessageAndArguments result) {
        if (!(message instanceof J.Binary)) {
            result.arguments.add(message);
            return result;
        }
        J.Binary concat = (J.Binary)message;
        if (concat.getLeft() instanceof J.Binary && ((J.Binary)concat.getLeft()).getOperator() == J.Binary.Type.Addition) {
            ParameterizedLogging.concatenationToLiteral(concat.getLeft(), result);
        } else if (concat.getLeft() instanceof J.Literal) {
            result.message = ParameterizedLogging.getLiteralValue((J.Literal)concat.getLeft()) + result.message;
        } else {
            result.message = "{}" + result.message;
            result.arguments.add(concat.getLeft());
        }
        if (concat.getRight() instanceof J.Binary && ((J.Binary)concat.getRight()).getOperator() == J.Binary.Type.Addition) {
            ParameterizedLogging.concatenationToLiteral(concat.getRight(), result);
        } else if (concat.getRight() instanceof J.Literal) {
            result.message = result.message + ParameterizedLogging.getLiteralValue((J.Literal)concat.getRight());
        } else {
            if (result.message.endsWith("#")) {
                result.message = result.message + "\\";
            }
            result.message = result.message + "{}";
            result.arguments.add(concat.getRight());
        }
        return result;
    }

    @Nullable
    private static Object getLiteralValue(J.Literal literal) {
        if (literal.getValueSource() == null || literal.getType() != JavaType.Primitive.String) {
            return literal.getValue();
        }
        return literal.getValueSource().substring(1, literal.getValueSource().length() - 1).replace("\\", "\\\\");
    }

    @ConstructorProperties(value={"methodPattern", "removeToString"})
    public ParameterizedLogging(String methodPattern, @Nullable Boolean removeToString) {
        this.methodPattern = methodPattern;
        this.removeToString = removeToString;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Nullable
    public Boolean getRemoveToString() {
        return this.removeToString;
    }

    @NonNull
    public String toString() {
        return "ParameterizedLogging(methodPattern=" + this.getMethodPattern() + ", removeToString=" + this.getRemoveToString() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterizedLogging)) {
            return false;
        }
        ParameterizedLogging other = (ParameterizedLogging)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$removeToString = this.getRemoveToString();
        Boolean other$removeToString = other.getRemoveToString();
        if (this$removeToString == null ? other$removeToString != null : !((Object)this$removeToString).equals(other$removeToString)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ParameterizedLogging;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $removeToString = this.getRemoveToString();
        result = result * 59 + ($removeToString == null ? 43 : ((Object)$removeToString).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    private static final class MessageAndArguments {
        private final List<Expression> arguments;
        private String message;

        private MessageAndArguments(String message, List<Expression> arguments) {
            this.message = message;
            this.arguments = arguments;
        }
    }
}

