/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class CompleteExceptionLogging
extends Recipe {
    private static final MethodMatcher LOGGER_DEBUG = new MethodMatcher("org.slf4j.Logger debug(..)");
    private static final MethodMatcher LOGGER_ERROR = new MethodMatcher("org.slf4j.Logger error(..)");
    private static final MethodMatcher LOGGER_INFO = new MethodMatcher("org.slf4j.Logger info(..)");
    private static final MethodMatcher LOGGER_TRACE = new MethodMatcher("org.slf4j.Logger trace(..)");
    private static final MethodMatcher LOGGER_WARN = new MethodMatcher("org.slf4j.Logger warn(..)");
    private static final MethodMatcher THROWABLE_GET_MESSAGE = new MethodMatcher("java.lang.Throwable getMessage()");
    private static final MethodMatcher THROWABLE_GET_LOCALIZED_MESSAGE = new MethodMatcher("java.lang.Throwable getLocalizedMessage()");

    public String getDisplayName() {
        return "Enhances logging of exceptions by including the full stack trace in addition to the exception message";
    }

    public String getDescription() {
        return "It is a common mistake to call Exception.getMessage() when passing an exception into a log method. Not all exception types have useful messages, and even if the message is useful this omits the stack trace. Including a complete stack trace of the error along with the exception message in the log allows developers to better understand the context of the exception and identify the source of the error more quickly and accurately.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("logging", "slf4j"));
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.slf4j.Logger", null);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                method = super.visitMethodInvocation(method, (Object)ctx);
                if (LOGGER_DEBUG.matches(method) || LOGGER_ERROR.matches(method) || LOGGER_INFO.matches(method) || LOGGER_TRACE.matches(method) || LOGGER_WARN.matches(method)) {
                    if (method.getArguments().isEmpty()) {
                        return method;
                    }
                    Expression lastParameter = (Expression)method.getArguments().get(method.getArguments().size() - 1);
                    if (lastParameter instanceof J.MethodInvocation && (THROWABLE_GET_MESSAGE.matches(lastParameter) || THROWABLE_GET_LOCALIZED_MESSAGE.matches(lastParameter))) {
                        J.MethodInvocation getMessageCall = (J.MethodInvocation)lastParameter;
                        if (method.getArguments().size() == 1) {
                            List args = method.getArguments();
                            args.add(0, CompleteExceptionLogging.buildEmptyString());
                            args.set(1, getMessageCall.getSelect());
                            return (J.MethodInvocation)this.autoFormat((J)method.withArguments(args), ctx);
                        }
                        Expression firstParameter = (Expression)method.getArguments().get(0);
                        if (!CompleteExceptionLogging.isStringLiteral(firstParameter)) {
                            return method;
                        }
                        String content = ((J.Literal)firstParameter).getValue().toString();
                        int placeholderCount = CompleteExceptionLogging.countPlaceholders(content);
                        List args = method.getArguments();
                        if (placeholderCount >= method.getArguments().size() - 1) {
                            args.add((Expression)getMessageCall.getSelect().withPrefix(getMessageCall.getPrefix()));
                        } else {
                            args.set(args.size() - 1, (Expression)getMessageCall.getSelect().withPrefix(getMessageCall.getPrefix()));
                        }
                        return (J.MethodInvocation)this.autoFormat((J)method.withArguments(args), ctx);
                    }
                }
                return method;
            }
        };
    }

    private static int countPlaceholders(String message) {
        int count = 0;
        Pattern pattern = Pattern.compile("\\{}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean isStringLiteral(Expression expression) {
        return expression instanceof J.Literal && TypeUtils.isString((JavaType)((J.Literal)expression).getType());
    }

    private static J.Literal buildEmptyString() {
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)"", "\"\"", null, JavaType.Primitive.String);
    }
}

