/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.log4j;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class ConvertJulEntering
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("java.util.logging.Logger entering(String, String, ..)", false);

    public String getDisplayName() {
        return "Rewrites JUL's Logger#entering method to Log4j API";
    }

    public String getDescription() {
        return "Replaces JUL's Logger#entering method calls to Log4j API Logger#traceEntry calls.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(METHOD_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (METHOD_MATCHER.matches((MethodCall)m)) {
                    List originalArgs = m.getArguments();
                    int originalArgCount = originalArgs.size();
                    if (3 < originalArgCount) {
                        return m;
                    }
                    ArrayList<Object> modifiedArgs = new ArrayList<Object>();
                    ArrayList<Object> modifiedTypes = new ArrayList<Object>();
                    if (2 < originalArgCount) {
                        modifiedArgs.add(this.buildNullString());
                        modifiedTypes.add(JavaType.Primitive.String);
                        modifiedArgs.add((Expression)originalArgs.get(2));
                        modifiedTypes.add(JavaType.buildType((String)"java.lang.Object[]"));
                    }
                    JavaType.Method mt = m.getMethodType().withParameterTypes(modifiedTypes);
                    JavaType.FullyQualified dt = mt.getDeclaringType().withFullyQualifiedName("org.apache.logging.log4j.Logger");
                    return m.withMethodType(mt).withName(m.getName().withSimpleName("traceEntry")).withArguments(modifiedArgs).withDeclaringType(dt);
                }
                return m;
            }

            private J.Literal buildNullString() {
                return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, "null", null, JavaType.Primitive.String);
            }
        });
    }

    @NonNull
    public String toString() {
        return "ConvertJulEntering()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertJulEntering)) {
            return false;
        }
        ConvertJulEntering other = (ConvertJulEntering)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ConvertJulEntering;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

