/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class StripToStringFromArguments
extends Recipe {
    private static final MethodMatcher TRACE_MATCHER = new MethodMatcher("org.slf4j.Logger trace(..)");
    private static final MethodMatcher DEBUG_MATCHER = new MethodMatcher("org.slf4j.Logger debug(..)");
    private static final MethodMatcher INFO_MATCHER = new MethodMatcher("org.slf4j.Logger info(..)");
    private static final MethodMatcher WARN_MATCHER = new MethodMatcher("org.slf4j.Logger warn(..)");
    private static final MethodMatcher ERROR_MATCHER = new MethodMatcher("org.slf4j.Logger error(..)");
    private static final MethodMatcher TO_STRING_MATCHER = new MethodMatcher("*..* toString()");

    public String getDisplayName() {
        return "Strip `toString()` from arguments";
    }

    public String getDescription() {
        return "Remove `.toString()` from logger call arguments; SLF4J will automatically call `toString()` on an argument when not a string, and do so only if the log level is enabled.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(TRACE_MATCHER), new UsesMethod(DEBUG_MATCHER), new UsesMethod(INFO_MATCHER), new UsesMethod(WARN_MATCHER), new UsesMethod(ERROR_MATCHER)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, ExecutionContext ctx) {
                m = super.visitMethodInvocation(m, (Object)ctx);
                if (!(TRACE_MATCHER.matches((MethodCall)m) || DEBUG_MATCHER.matches((MethodCall)m) || INFO_MATCHER.matches((MethodCall)m) || WARN_MATCHER.matches((MethodCall)m) || ERROR_MATCHER.matches((MethodCall)m))) {
                    return m;
                }
                int firstFormatArgIndex = TypeUtils.isOfClassType((JavaType)((Expression)m.getArguments().get(0)).getType(), (String)"org.slf4j.Marker") ? 2 : 1;
                int lastArgIndex = m.getArguments().size() - 1;
                return m.withArguments(ListUtils.map((List)m.getArguments(), (index, arg) -> {
                    if (index < firstFormatArgIndex) {
                        return arg;
                    }
                    if (arg instanceof J.MethodInvocation) {
                        J.MethodInvocation toStringInvocation = (J.MethodInvocation)arg;
                        if (TO_STRING_MATCHER.matches(toStringInvocation.getMethodType()) && toStringInvocation.getSelect() != null && (index != lastArgIndex || !TypeUtils.isAssignableTo((String)"java.lang.Throwable", (JavaType)toStringInvocation.getSelect().getType()))) {
                            return (Expression)toStringInvocation.getSelect().withPrefix(toStringInvocation.getPrefix());
                        }
                    }
                    return arg;
                }));
            }
        });
    }
}

