/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class JulToSlf4jLambdaSupplierRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace JUL active Level check with corresponding SLF4J method calls";
    }

    public String getDescription() {
        return "Replace calls to `Logger.isLoggable(Level)` with the corresponding SLF4J method calls.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new JulToSlf4jSupplierFinestRecipe(), new JulToSlf4jSupplierFinerRecipe(), new JulToSlf4jSupplierFineRecipe(), new JulToSlf4jSupplierConfigRecipe(), new JulToSlf4jSupplierInfoRecipe(), new JulToSlf4jSupplierWarningRecipe(), new JulToSlf4jSupplierSevereRecipe(), new JulToSlf4jSupplierLogFinestRecipe(), new JulToSlf4jSupplierLogFinerRecipe(), new JulToSlf4jSupplierLogFineRecipe(), new JulToSlf4jSupplierLogConfigRecipe(), new JulToSlf4jSupplierLogInfoRecipe(), new JulToSlf4jSupplierLogWarningRecipe(), new JulToSlf4jSupplierLogSevereRecipe(), new JulToSlf4jSupplierLogAllRecipe()});
    }

    @NullMarked
    public static class JulToSlf4jSupplierFinestRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.finest(Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.finest(Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.finest(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atTrace().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger finest(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierFinerRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.finer(Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.finer(Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.finer(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atTrace().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger finer(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierFineRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.fine(Supplier<String>)` with SLF4J's `Logger.atDebug().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.fine(Supplier<String>)` with `org.slf4j.Logger.atDebug().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.fine(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atDebug().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger fine(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierConfigRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.config(Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.config(Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.config(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atInfo().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger config(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierInfoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.info(Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.info(Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.info(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atInfo().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger info(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierWarningRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.warning(Supplier<String>)` with SLF4J's `Logger.atWarn().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.warning(Supplier<String>)` with `org.slf4j.Logger.atWarn().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.warning(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atWarn().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger warning(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierSevereRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.severe(Supplier<String>)` with SLF4J's `Logger.atError().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.severe(Supplier<String>)` with `org.slf4j.Logger.atError().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.severe(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atError().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger severe(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierLogFinestRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.FINEST, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINEST, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINEST, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        this.maybeRemoveImport("java.util.logging.Level");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atTrace().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierLogFinerRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.FINER, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINER, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINER, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        this.maybeRemoveImport("java.util.logging.Level");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atTrace().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierLogFineRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.FINE, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINE, Supplier<String>)` with `org.slf4j.Logger.atDebug().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINE, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        this.maybeRemoveImport("java.util.logging.Level");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atDebug().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierLogConfigRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.CONFIG, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.CONFIG, Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.CONFIG, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        this.maybeRemoveImport("java.util.logging.Level");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atInfo().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierLogInfoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.INFO, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.INFO, Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.INFO, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        this.maybeRemoveImport("java.util.logging.Level");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atInfo().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierLogWarningRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.WARNING, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.WARNING, Supplier<String>)` with `org.slf4j.Logger.atWarn().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.WARNING, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        this.maybeRemoveImport("java.util.logging.Level");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atWarn().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierLogSevereRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.SEVERE, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.SEVERE, Supplier<String>)` with `org.slf4j.Logger.atError().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.SEVERE, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        this.maybeRemoveImport("java.util.logging.Level");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atError().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierLogAllRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `Logger.log(Level.ALL, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.ALL, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.ALL, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.logging.Logger");
                        this.maybeRemoveImport("java.util.logging.Level");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atTrace().log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

