/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class ArgumentArrayToVarargs
extends Recipe {
    private static final MethodMatcher LOGGER_METHOD = new MethodMatcher("*..*Log* *(.., Object[])");

    public String getDisplayName() {
        return "Unpack Logger method `new Object[] {...}` into varargs";
    }

    public String getDescription() {
        return "For Logger methods that support varargs, convert any final explicit `Object[]` arguments into their unpacked values.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(LOGGER_METHOD), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (LOGGER_METHOD.matches((MethodCall)mi)) {
                    return mi.withArguments(ListUtils.flatMap((List)mi.getArguments(), (index, lastArg) -> {
                        J.NewArray arrayArg;
                        if (index == mi.getArguments().size() - 1 && lastArg instanceof J.NewArray && (arrayArg = (J.NewArray)lastArg).getType() instanceof JavaType.Array && TypeUtils.isObject((JavaType)((JavaType.Array)arrayArg.getType()).getElemType()) && (mi.getMethodType() == null || mi.getMethodType().hasFlags(new Flag[]{Flag.Varargs}))) {
                            List arrayElements = arrayArg.getInitializer();
                            if (arrayElements == null || arrayElements.isEmpty() || arrayElements.get(0) instanceof J.Empty) {
                                return null;
                            }
                            return ListUtils.mapFirst((List)arrayElements, first -> (Expression)first.withPrefix(lastArg.getPrefix()));
                        }
                        return lastArg;
                    }));
                }
                return mi;
            }
        });
    }
}

