/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.jboss;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class FormattedArgumentsToVMethodRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace deprecated JBoss Logging Logger formatted message invocations with the v-version of methods";
    }

    public String getDescription() {
        return "Replace `logger.level(\"hello {0}\", arg)` with `logger.levelv(\"hello {0}\", arg)`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new TraceToVTraceRecipe(), new TraceToVTraceWithThrowableRecipe(), new DebugToVDebugRecipe(), new DebugToVDebugWithThrowableRecipe(), new InfoToVInfoRecipe(), new InfoToVInfoWithThrowableRecipe(), new WarnToVWarnRecipe(), new WarnToVWarnWithThrowableRecipe(), new ErrorToVErrorRecipe(), new ErrorToVErrorWithThrowableRecipe(), new FatalToVFatalRecipe(), new FatalToVFatalWithThrowableRecipe()});
    }

    @NullMarked
    public static class TraceToVTraceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.TraceToVTrace`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class TraceToVTrace {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args) {\n        logger.trace(message, args);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args) {\n        logger.tracev(message, args);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.trace(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.tracev(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger trace(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TraceToVTraceWithThrowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.TraceToVTraceWithThrowable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class TraceToVTraceWithThrowable {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args, Throwable t) {\n        logger.trace((Object)message, args, t);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args, Throwable t) {\n        logger.tracev(message, args, t);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.trace((Object)#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.tracev(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger trace(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DebugToVDebugRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.DebugToVDebug`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class DebugToVDebug {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args) {\n        logger.debug(message, args);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args) {\n        logger.debugv(message, args);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.debug(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.debugv(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger debug(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DebugToVDebugWithThrowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.DebugToVDebugWithThrowable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class DebugToVDebugWithThrowable {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args, Throwable t) {\n        logger.debug((Object)message, args, t);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args, Throwable t) {\n        logger.debugv(message, args, t);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.debug((Object)#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.debugv(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger debug(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InfoToVInfoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.InfoToVInfo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class InfoToVInfo {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args) {\n        logger.info(message, args);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args) {\n        logger.infov(message, args);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.info(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.infov(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger info(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class InfoToVInfoWithThrowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.InfoToVInfoWithThrowable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class InfoToVInfoWithThrowable {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args, Throwable t) {\n        logger.info((Object)message, args, t);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args, Throwable t) {\n        logger.infov(message, args, t);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.info((Object)#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.infov(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger info(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class WarnToVWarnRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.WarnToVWarn`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class WarnToVWarn {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args) {\n        logger.warn(message, args);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args) {\n        logger.warnv(message, args);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.warn(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.warnv(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger warn(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class WarnToVWarnWithThrowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.WarnToVWarnWithThrowable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class WarnToVWarnWithThrowable {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args, Throwable t) {\n        logger.warn((Object)message, args, t);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args, Throwable t) {\n        logger.warnv(message, args, t);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.warn((Object)#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.warnv(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger warn(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ErrorToVErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.ErrorToVError`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class ErrorToVError {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args) {\n        logger.error(message, args);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args) {\n        logger.errorv(message, args);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.error(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.errorv(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger error(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ErrorToVErrorWithThrowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.ErrorToVErrorWithThrowable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class ErrorToVErrorWithThrowable {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args, Throwable t) {\n        logger.error((Object)message, args, t);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args, Throwable t) {\n        logger.errorv(message, args, t);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.error((Object)#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.errorv(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger error(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FatalToVFatalRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.FatalToVFatal`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class FatalToVFatal {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args) {\n        logger.fatal(message, args);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args) {\n        logger.fatalv(message, args);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.fatal(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.fatalv(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger fatal(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FatalToVFatalWithThrowableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FormattedArgumentsToVMethod.FatalToVFatalWithThrowable`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\npublic static class FatalToVFatalWithThrowable {\n    \n    @BeforeTemplate\n    void before(Logger logger, String message, Object[] args, Throwable t) {\n        logger.fatal((Object)message, args, t);\n    }\n    \n    @AfterTemplate\n    void after(Logger logger, String message, Object[] args, Throwable t) {\n        logger.fatalv(message, args, t);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.fatal((Object)#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{logger:any(org.jboss.logging.Logger)}.fatalv(#{message:any(java.lang.String)}, #{args:any(java.lang.Object[])}, #{t:any(java.lang.Throwable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jboss-logging-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2), matcher.parameter(3)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesMethod("org.jboss.logging.Logger fatal(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

