/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public final class CatchBlockLogLevel
extends Recipe {
    private static final MethodMatcher SLF4J_MATCHER = new MethodMatcher("org.slf4j.Logger *(..)");
    private static final MethodMatcher LOG4J1_MATCHER = new MethodMatcher("org.apache.log4j.Category *(..)");
    private static final MethodMatcher LOG4J2_MATCHER = new MethodMatcher("org.apache.logging.log4j.Logger *(..)");
    private static final MethodMatcher LOGBACK_MATCHER = new MethodMatcher("ch.qos.logback.classic.Logger *(..)");

    @NlsRewrite.DisplayName
    public String getDisplayName() {
        return "Catch block log level";
    }

    @NlsRewrite.Description
    public String getDescription() {
        return "Sometimes exceptions are caught and logged at the wrong log level. This will set the log level of logging statements within a catch block not containing an exception to \"warn\", and the log level of logging statements containing an exception to \"error\". This supports SLF4J, Log4J1, Log4j2, and Logback.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(SLF4J_MATCHER), new UsesMethod(LOG4J1_MATCHER), new UsesMethod(LOG4J2_MATCHER), new UsesMethod(LOGBACK_MATCHER)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (!(SLF4J_MATCHER.matches((MethodCall)m) || LOG4J1_MATCHER.matches((MethodCall)m) || LOG4J2_MATCHER.matches((MethodCall)m) || LOGBACK_MATCHER.matches((MethodCall)m))) {
                    return m;
                }
                Object maybeCatch = this.getCursor().dropParentUntil(it -> it == "root" || it instanceof J.Try.Catch || it instanceof J.Try || it instanceof J.MethodDeclaration || it instanceof J.Lambda || it instanceof J.ClassDeclaration).getValue();
                if (!(maybeCatch instanceof J.Try.Catch)) {
                    return m;
                }
                if (this.referencesException((J)m, ctx)) {
                    if ("info".equals(m.getSimpleName()) || "debug".equals(m.getSimpleName()) || "trace".equals(m.getSimpleName()) || "warn".equals(m.getSimpleName())) {
                        JavaType.Method mt = m.getMethodType() == null ? null : m.getMethodType().withName("error");
                        m = m.withName(m.getName().withSimpleName("error").withType((JavaType)mt)).withMethodType(mt);
                    }
                } else if ("info".equals(m.getSimpleName()) || "debug".equals(m.getSimpleName()) || "trace".equals(m.getSimpleName())) {
                    JavaType.Method mt = m.getMethodType() == null ? null : m.getMethodType().withName("warn");
                    m = m.withName(m.getName().withSimpleName("warn").withType((JavaType)mt)).withMethodType(mt);
                }
                return m;
            }

            private boolean referencesException(J j, ExecutionContext ctx) {
                final AtomicBoolean found = new AtomicBoolean(false);
                new JavaIsoVisitor<ExecutionContext>(){

                    public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                        J.Identifier i = super.visitIdentifier(identifier, (Object)ctx);
                        found.set(found.get() || TypeUtils.isAssignableTo((String)"java.lang.Throwable", (JavaType)i.getType()));
                        return i;
                    }
                }.visit((Tree)j, (Object)ctx);
                return found.get();
            }
        });
    }

    @Generated
    public CatchBlockLogLevel() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "CatchBlockLogLevel()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatchBlockLogLevel)) {
            return false;
        }
        CatchBlockLogLevel other = (CatchBlockLogLevel)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CatchBlockLogLevel;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

