/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.logback;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ConfigureLoggerLevel
extends Recipe {
    @Option(displayName="Class name", description="The fully qualified class name to configure the log level for", example="com.example.MyClass")
    private final String className;
    @Option(displayName="Log level", description="The log level to set for the class", valid={"trace", "debug", "info", "warn", "error", "off"}, example="off")
    private final LogLevel logLevel;

    @NlsRewrite.DisplayName
    public String getDisplayName() {
        return "Configure logback logger level";
    }

    @NlsRewrite.Description
    public String getDescription() {
        return "Within logback.xml configuration files sets the specified log level for a particular class. Will not create a logback.xml if one does not already exist.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles("**/logback.xml"), (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){
            final XPathMatcher loggerMatcher;
            {
                this.loggerMatcher = new XPathMatcher("/configuration/logger[@name='" + ConfigureLoggerLevel.this.className + "']");
            }

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document x = super.visitDocument(document, (Object)ctx);
                if (x == document && !((Boolean)this.getCursor().getMessage("found", (Object)false)).booleanValue()) {
                    Xml.Tag l = Xml.Tag.build((String)("\n<logger name=\"" + ConfigureLoggerLevel.this.className + "\" level=\"" + ConfigureLoggerLevel.this.logLevel.name() + "\"/>"));
                    l = (Xml.Tag)this.autoFormat((Xml)l, ctx, new Cursor(this.getCursor(), (Object)x.getRoot()));
                    x = x.withRoot(x.getRoot().withContent(ListUtils.concat((List)x.getRoot().getContent(), (Object)l)));
                }
                return x;
            }

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, (Object)ctx);
                if (this.loggerMatcher.matches(this.getCursor())) {
                    this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "found", (Object)true);
                    t = t.withAttributes(ListUtils.map((List)t.getAttributes(), a -> {
                        if (a != null && "level".equals(a.getKeyAsString()) && !ConfigureLoggerLevel.this.logLevel.name().equals(a.getValueAsString())) {
                            return a.withValue(a.getValue().withValue(ConfigureLoggerLevel.this.logLevel.name()));
                        }
                        return a;
                    }));
                }
                return t;
            }
        });
    }

    @ConstructorProperties(value={"className", "logLevel"})
    @Generated
    public ConfigureLoggerLevel(String className, LogLevel logLevel) {
        this.className = className;
        this.logLevel = logLevel;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ConfigureLoggerLevel(className=" + this.getClassName() + ", logLevel=" + (Object)((Object)this.getLogLevel()) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigureLoggerLevel)) {
            return false;
        }
        ConfigureLoggerLevel other = (ConfigureLoggerLevel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        LogLevel this$logLevel = this.getLogLevel();
        LogLevel other$logLevel = other.getLogLevel();
        return !(this$logLevel == null ? other$logLevel != null : !((Object)((Object)this$logLevel)).equals((Object)other$logLevel));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ConfigureLoggerLevel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        LogLevel $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : ((Object)((Object)$logLevel)).hashCode());
        return result;
    }

    public static enum LogLevel {
        trace,
        debug,
        info,
        warn,
        error,
        off;

    }
}

