/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.marker.GradleBuildscript;
import org.openrewrite.gradle.marker.GradlePluginDescriptor;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class MicronautVersionHelper {
    private static final String GROUP_ID = "io.micronaut";
    private static final String V4_GROUP_ID = "io.micronaut.platform";
    private static final String ARTIFACT_ID = "micronaut-parent";
    private static final LatestRelease LATEST_RELEASE = new LatestRelease(null);
    public static final MavenRepository GRADLE_PLUGIN_REPO = new MavenRepository("gradle-plugins", "https://plugins.gradle.org/m2/", "true", "false", true, null, null, Boolean.valueOf(true));

    public static Optional<String> getNewerVersion(String versionPattern, String currentVersion, ExecutionContext ctx) throws MavenDownloadingException {
        VersionComparator versionComparator = (VersionComparator)Semver.validate((String)versionPattern, null).getValue();
        assert (versionComparator != null);
        String groupId = "4".equals(Semver.majorVersion((String)versionPattern)) ? V4_GROUP_ID : GROUP_ID;
        MavenMetadata mavenMetadata = new MavenPomDownloader(Collections.emptyMap(), ctx).downloadMetadata(new GroupArtifact(groupId, ARTIFACT_ID), null, Collections.emptyList());
        ArrayList<String> availableVersions = new ArrayList<String>();
        for (String v2 : mavenMetadata.getVersioning().getVersions()) {
            if (!versionComparator.isValid(null, v2)) continue;
            availableVersions.add(v2);
        }
        return availableVersions.stream().filter(v -> LATEST_RELEASE.compare(null, currentVersion, v) < 0).max((Comparator<String>)LATEST_RELEASE);
    }

    public static Optional<String> getNewerGradlePluginVersion(String pluginId, String versionPattern, String currentVersion, ExecutionContext ctx) throws MavenDownloadingException {
        MavenRepository gradlePluginsRepo = new MavenRepository("gradle-plugins", "https://plugins.gradle.org/m2/", "true", "false", true, null, null, Boolean.valueOf(true));
        GradleSettings gradleSettings = new GradleSettings(Tree.randomId(), Collections.singletonList(gradlePluginsRepo), Collections.singletonList(new GradlePluginDescriptor("io.micronaut.gradle.MicronautApplicationPlugin", null)), Collections.emptyMap(), new GradleBuildscript(Tree.randomId(), Collections.singletonList(gradlePluginsRepo), Collections.emptyMap()));
        return Optional.ofNullable(new DependencyVersionSelector(null, null, gradleSettings).select(new GroupArtifactVersion(pluginId, pluginId + ".gradle.plugin", currentVersion), "classpath", versionPattern, null, ctx));
    }

    private MicronautVersionHelper() {
    }
}

