/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.micronaut.MicronautVersionHelper;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.semver.Semver;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeMicronautMavenPropertyVersion
extends Recipe {
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="4.x")
    private final String newVersion;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, null));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade `micronaut.version` Maven property";
    }

    public String getDescription() {
        return "Set the maven micronaut.version property according to a node-style semver selector or to a specific version number.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, (Object)ctx);
                MavenResolutionResult model = this.getResolutionResult();
                String currentVersion = (String)model.getPom().getProperties().get("micronaut.version");
                if (currentVersion != null && !currentVersion.isEmpty()) {
                    try {
                        MicronautVersionHelper.getNewerVersion(UpgradeMicronautMavenPropertyVersion.this.newVersion, currentVersion, ctx).ifPresent(latestVersion -> this.doAfterVisit(new ChangePropertyValue("micronaut.version", latestVersion, Boolean.valueOf(false), Boolean.valueOf(true)).getVisitor()));
                    }
                    catch (MavenDownloadingException e) {
                        return (Xml.Document)Markup.warn((Tree)document, (Throwable)e);
                    }
                }
                return d;
            }
        };
    }

    @ConstructorProperties(value={"newVersion"})
    @Generated
    public UpgradeMicronautMavenPropertyVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeMicronautMavenPropertyVersion(newVersion=" + this.getNewVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeMicronautMavenPropertyVersion)) {
            return false;
        }
        UpgradeMicronautMavenPropertyVersion other = (UpgradeMicronautMavenPropertyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeMicronautMavenPropertyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }
}

