/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.dependencies.AddDependency;
import org.openrewrite.java.micronaut.FindYamlConfig;

public class AddSnakeYamlDependencyIfNeeded
extends ScanningRecipe<Accumulator> {
    public String getDisplayName() {
        return "Add `snakeyaml` dependency if needed";
    }

    public String getDescription() {
        return "This recipe will add the `snakeyaml` dependency to a Micronaut 4 application that uses yaml configuration.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(false, AddSnakeYamlDependencyIfNeeded.addDependencyRecipe().getInitialValue(ctx));
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        final AddDependency addDependencyRecipe = AddSnakeYamlDependencyIfNeeded.addDependencyRecipe();
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    TreeVisitor addDependencyScanner;
                    if (!acc.usesYamlConfig) {
                        boolean bl = acc.usesYamlConfig = tree != new FindYamlConfig().getVisitor().visit(tree, (Object)ctx);
                    }
                    if ((addDependencyScanner = addDependencyRecipe.getScanner(acc.getAddDependencyAccumulator())).isAcceptable((SourceFile)tree, (Object)ctx)) {
                        addDependencyScanner.visit(tree, (Object)ctx);
                    }
                }
                return super.visit(tree, (Object)ctx);
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        return Preconditions.check((boolean)acc.usesYamlConfig, (TreeVisitor)AddSnakeYamlDependencyIfNeeded.addDependencyRecipe().getVisitor(acc.getAddDependencyAccumulator()));
    }

    private static AddDependency addDependencyRecipe() {
        return new AddDependency("org.yaml", "snakeyaml", null, null, null, null, null, null, "runtimeOnly", "runtime", null, null, null, null);
    }

    public static class Accumulator {
        boolean usesYamlConfig;
        AddDependency.Accumulator addDependencyAccumulator;

        @Generated
        public boolean isUsesYamlConfig() {
            return this.usesYamlConfig;
        }

        @Generated
        public AddDependency.Accumulator getAddDependencyAccumulator() {
            return this.addDependencyAccumulator;
        }

        @Generated
        public void setUsesYamlConfig(boolean usesYamlConfig) {
            this.usesYamlConfig = usesYamlConfig;
        }

        @Generated
        public void setAddDependencyAccumulator(AddDependency.Accumulator addDependencyAccumulator) {
            this.addDependencyAccumulator = addDependencyAccumulator;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUsesYamlConfig() != other.isUsesYamlConfig()) {
                return false;
            }
            AddDependency.Accumulator this$addDependencyAccumulator = this.getAddDependencyAccumulator();
            AddDependency.Accumulator other$addDependencyAccumulator = other.getAddDependencyAccumulator();
            return !(this$addDependencyAccumulator == null ? other$addDependencyAccumulator != null : !this$addDependencyAccumulator.equals(other$addDependencyAccumulator));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUsesYamlConfig() ? 79 : 97);
            AddDependency.Accumulator $addDependencyAccumulator = this.getAddDependencyAccumulator();
            result = result * 59 + ($addDependencyAccumulator == null ? 43 : $addDependencyAccumulator.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddSnakeYamlDependencyIfNeeded.Accumulator(usesYamlConfig=" + this.isUsesYamlConfig() + ", addDependencyAccumulator=" + this.getAddDependencyAccumulator() + ")";
        }

        @ConstructorProperties(value={"usesYamlConfig", "addDependencyAccumulator"})
        @Generated
        public Accumulator(boolean usesYamlConfig, AddDependency.Accumulator addDependencyAccumulator) {
            this.usesYamlConfig = usesYamlConfig;
            this.addDependencyAccumulator = addDependencyAccumulator;
        }
    }
}

