/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.AddDependency;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.search.FindProperties;
import org.openrewrite.xml.tree.Xml;

public class AddTestResourcesClientDependencyIfNeeded
extends Recipe {
    public String getDisplayName() {
        return "Add `micronaut-test-resources-client` if needed";
    }

    public String getDescription() {
        return "Add the `micronaut-test-resources-client` dependency to pom.xml if `test.resources.client.enabled property=true`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        MavenIsoVisitor<ExecutionContext> resourcesEnabled = new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document maven = super.visitDocument(document, (Object)ctx);
                Optional testResourcesProp = FindProperties.find((Xml.Document)document, (String)"micronaut\\.test\\.resources\\.enabled").stream().findFirst();
                if ("true".equals(testResourcesProp.flatMap(Xml.Tag::getValue).orElse("false"))) {
                    return (Xml.Document)SearchResult.found((Tree)maven);
                }
                return maven;
            }
        };
        AddDependency addDependency = new AddDependency("io.micronaut.testresources", "micronaut-test-resources-client", "LATEST", null, "provided", null, null, null, null, null, null, null);
        return Preconditions.check((TreeVisitor)resourcesEnabled, (TreeVisitor)addDependency.getVisitor());
    }
}

